/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;

public abstract class AbstractXStreamSerializer
implements Serializer {
    private final XStream xStream;
    private final Charset charset;
    private final RevisionResolver revisionResolver;
    private final Converter converter;

    protected AbstractXStreamSerializer(Builder builder) {
        builder.validate();
        this.charset = builder.charset;
        this.xStream = builder.xStream;
        this.converter = builder.converter;
        this.revisionResolver = builder.revisionResolver;
        if (this.converter instanceof ChainingConverter) {
            this.registerConverters((ChainingConverter)this.converter);
        }
        this.xStream.addImmutableType(UUID.class, true);
        this.xStream.alias("domain-event", GenericDomainEventMessage.class);
        this.xStream.alias("event", GenericEventMessage.class);
        this.xStream.alias("command", GenericCommandMessage.class);
        this.xStream.alias("uuid", UUID.class);
        this.xStream.alias("meta-data", MetaData.class);
        this.xStream.registerConverter((com.thoughtworks.xstream.converters.Converter)new MetaDataConverter(this.xStream.getMapper()));
    }

    protected abstract void registerConverters(ChainingConverter var1);

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedType) {
        T result = this.doSerialize(object, expectedType, this.xStream);
        return new SimpleSerializedObject<T>(result, expectedType, this.typeForClass(ObjectUtils.nullSafeTypeOf(object)));
    }

    protected abstract <T> T doSerialize(Object var1, Class<T> var2, XStream var3);

    protected abstract Object doDeserialize(SerializedObject var1, XStream var2);

    protected <S, T> T convert(S source, Class<S> sourceType, Class<T> targetType) {
        return this.getConverter().convert(source, sourceType, targetType);
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        if (SerializedType.emptyType().equals(serializedObject.getType())) {
            return null;
        }
        if (UnknownSerializedType.class.isAssignableFrom(this.classForType(serializedObject.getType()))) {
            return (T)new UnknownSerializedType(this, serializedObject);
        }
        return (T)this.doDeserialize(serializedObject, this.xStream);
    }

    @Override
    public Class classForType(SerializedType type) {
        if (SerializedType.emptyType().equals(type)) {
            return Void.class;
        }
        try {
            return this.xStream.getMapper().realClass(type.getName());
        }
        catch (CannotResolveClassException e) {
            return UnknownSerializedType.class;
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return SimpleSerializedType.emptyType();
        }
        return new SimpleSerializedType(this.typeIdentifierOf(type), this.revisionOf(type));
    }

    public void addAlias(String name, Class type) {
        this.xStream.alias(name, type);
    }

    public void addPackageAlias(String alias, String pkgName) {
        this.xStream.aliasPackage(alias, pkgName);
    }

    public void addFieldAlias(String alias, Class definedIn, String fieldName) {
        this.xStream.aliasField(alias, definedIn, fieldName);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    private String typeIdentifierOf(Class<?> type) {
        return this.xStream.getMapper().serializedClass(type);
    }

    private static final class MetaDataConverter
    extends MapConverter {
        public MetaDataConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return MetaData.class.equals((Object)type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            MetaData metaData = (MetaData)source;
            if (!metaData.isEmpty()) {
                super.marshal(new HashMap<String, Object>(metaData), writer, context);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (!reader.hasMoreChildren()) {
                return MetaData.emptyInstance();
            }
            HashMap contents = new HashMap();
            this.populateMap(reader, context, contents);
            if (contents.isEmpty()) {
                return MetaData.emptyInstance();
            }
            return MetaData.from(contents);
        }
    }

    public static abstract class Builder {
        private XStream xStream;
        private Charset charset = Charset.forName("UTF-8");
        private RevisionResolver revisionResolver = new AnnotationRevisionResolver();
        private Converter converter = new ChainingConverter();

        public Builder xStream(XStream xStream) {
            BuilderUtils.assertNonNull(xStream, "XStream may not be null");
            this.xStream = xStream;
            return this;
        }

        public Builder charset(Charset charset) {
            BuilderUtils.assertNonNull(charset, "Charset may not be null");
            this.charset = charset;
            return this;
        }

        public Builder revisionResolver(RevisionResolver revisionResolver) {
            BuilderUtils.assertNonNull(revisionResolver, "RevisionResolver may not be null");
            this.revisionResolver = revisionResolver;
            return this;
        }

        public Builder converter(Converter converter) {
            BuilderUtils.assertNonNull(converter, "Converter may not be null");
            this.converter = converter;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.xStream, "The XStream is a hard requirement and should be provided");
        }
    }
}

