/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCommandBus.class);
    private final TransactionManager transactionManager;
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private RollbackConfiguration rollbackConfiguration;
    private final ConcurrentMap<String, MessageHandler<? super CommandMessage<?>>> subscriptions = new ConcurrentHashMap();
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();

    private SimpleCommandBus() {
        this(new Builder());
    }

    protected SimpleCommandBus(Builder builder) {
        builder.validate();
        this.transactionManager = builder.transactionManager;
        this.messageMonitor = builder.messageMonitor;
        this.rollbackConfiguration = builder.rollbackConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, ? super R> callback) {
        this.doDispatch(this.intercept(command), callback);
    }

    protected <C> CommandMessage<C> intercept(CommandMessage<C> command) {
        CommandMessage<C> commandToDispatch = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            commandToDispatch = interceptor.handle(commandToDispatch);
        }
        return commandToDispatch;
    }

    protected <C, R> void doDispatch(CommandMessage<C> command, CommandCallback<? super C, ? super R> callback) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(command);
        Optional<MessageHandler<CommandMessage<?>>> optionalHandler = this.findCommandHandlerFor(command);
        if (optionalHandler.isPresent()) {
            this.handle(command, optionalHandler.get(), new MonitorAwareCallback<C, R>(callback, monitorCallback));
        } else {
            NoHandlerForCommandException exception = new NoHandlerForCommandException(String.format("No handler was subscribed to command [%s]", command.getCommandName()));
            monitorCallback.reportFailure(exception);
            callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage(exception));
        }
    }

    private Optional<MessageHandler<? super CommandMessage<?>>> findCommandHandlerFor(CommandMessage<?> command) {
        return Optional.ofNullable(this.subscriptions.get(command.getCommandName()));
    }

    protected <C, R> void handle(CommandMessage<C> command, MessageHandler<? super CommandMessage<?>> handler, CommandCallback<? super C, ? super R> callback) {
        if (logger.isDebugEnabled()) {
            logger.debug("Handling command [{}]", (Object)command.getCommandName());
        }
        DefaultUnitOfWork<CommandMessage<C>> unitOfWork = DefaultUnitOfWork.startAndGet(command);
        unitOfWork.attachTransaction(this.transactionManager);
        DefaultInterceptorChain chain = new DefaultInterceptorChain(unitOfWork, this.handlerInterceptors, handler);
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage(unitOfWork.executeWithResult(chain::proceed, this.rollbackConfiguration));
        callback.onResult(command, resultMessage);
    }

    @Override
    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        this.subscriptions.put(commandName, handler);
        return () -> this.subscriptions.remove(commandName, handler);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public void setRollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
        this.rollbackConfiguration = rollbackConfiguration;
    }

    public static class Builder {
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private MessageMonitor<? super CommandMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private RollbackConfiguration rollbackConfiguration = RollbackConfigurationType.UNCHECKED_EXCEPTIONS;

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder messageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            BuilderUtils.assertNonNull(rollbackConfiguration, "RollbackConfiguration may not be null");
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public SimpleCommandBus build() {
            return new SimpleCommandBus(this);
        }

        protected void validate() {
        }
    }
}

