/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc.statements;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.TimestampWriter;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public abstract class JdbcEventStorageEngineStatements {
    private JdbcEventStorageEngineStatements() {
    }

    public static PreparedStatement createTokenAt(Connection connection, EventSchema schema, Instant dateTime) throws SQLException {
        String sql = "SELECT min(" + schema.globalIndexColumn() + ") - 1 FROM " + schema.domainEventTable() + " WHERE " + schema.timestampColumn() + " >= ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, DateTimeUtils.formatInstant((TemporalAccessor)dateTime));
        return statement;
    }

    public static PreparedStatement appendEvents(Connection connection, EventSchema schema, Class<?> dataType, List<? extends EventMessage<?>> events, Serializer serializer, TimestampWriter timestampWriter) throws SQLException {
        String sql = "INSERT INTO " + schema.domainEventTable() + " (" + schema.domainEventFields() + ") VALUES (?,?,?,?,?,?,?,?,?)";
        PreparedStatement statement = connection.prepareStatement(sql);
        for (EventMessage<?> eventMessage : events) {
            DomainEventMessage event = EventUtils.asDomainEventMessage(eventMessage);
            SerializedObject payload = event.serializePayload(serializer, dataType);
            SerializedObject metaData = event.serializeMetaData(serializer, dataType);
            statement.setString(1, event.getIdentifier());
            statement.setString(2, event.getAggregateIdentifier());
            statement.setLong(3, event.getSequenceNumber());
            statement.setString(4, event.getType());
            timestampWriter.writeTimestamp(statement, 5, event.getTimestamp());
            statement.setString(6, payload.getType().getName());
            statement.setString(7, payload.getType().getRevision());
            statement.setObject(8, payload.getData());
            statement.setObject(9, metaData.getData());
            statement.addBatch();
        }
        return statement;
    }

    public static PreparedStatement lastSequenceNumberFor(Connection connection, EventSchema schema, String aggregateIdentifier) throws SQLException {
        String sql = "SELECT max(" + schema.sequenceNumberColumn() + ") FROM " + schema.domainEventTable() + " WHERE " + schema.aggregateIdentifierColumn() + " = ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, aggregateIdentifier);
        return statement;
    }

    public static PreparedStatement createTailToken(Connection connection, EventSchema schema) throws SQLException {
        String sql = "SELECT min(" + schema.globalIndexColumn() + ") - 1 FROM " + schema.domainEventTable();
        return connection.prepareStatement(sql);
    }

    public static PreparedStatement createHeadToken(Connection connection, EventSchema schema) throws SQLException {
        String sql = "SELECT max(" + schema.globalIndexColumn() + ") FROM " + schema.domainEventTable();
        return connection.prepareStatement(sql);
    }

    public static PreparedStatement appendSnapshot(Connection connection, EventSchema schema, Class<?> dataType, DomainEventMessage<?> snapshot, Serializer serializer, TimestampWriter timestampWriter) throws SQLException {
        String sql = "INSERT INTO " + schema.snapshotTable() + " (" + schema.domainEventFields() + ") VALUES (?,?,?,?,?,?,?,?,?)";
        PreparedStatement statement = connection.prepareStatement(sql);
        SerializedObject payload = snapshot.serializePayload(serializer, dataType);
        SerializedObject metaData = snapshot.serializeMetaData(serializer, dataType);
        statement.setString(1, snapshot.getIdentifier());
        statement.setString(2, snapshot.getAggregateIdentifier());
        statement.setLong(3, snapshot.getSequenceNumber());
        statement.setString(4, snapshot.getType());
        timestampWriter.writeTimestamp(statement, 5, snapshot.getTimestamp());
        statement.setString(6, payload.getType().getName());
        statement.setString(7, payload.getType().getRevision());
        statement.setObject(8, payload.getData());
        statement.setObject(9, metaData.getData());
        return statement;
    }

    public static PreparedStatement deleteSnapshots(Connection connection, EventSchema schema, String aggregateIdentifier, long sequenceNumber) throws SQLException {
        String sql = "DELETE FROM " + schema.snapshotTable() + " WHERE " + schema.aggregateIdentifierColumn() + " = ? AND " + schema.sequenceNumberColumn() + " < ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, aggregateIdentifier);
        statement.setLong(2, sequenceNumber);
        return statement;
    }

    public static PreparedStatement fetchTrackedEvents(Connection connection, EventSchema schema, long index) throws SQLException {
        String sql = "SELECT min(" + schema.globalIndexColumn() + ") FROM " + schema.domainEventTable() + " WHERE " + schema.globalIndexColumn() + " > ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setLong(1, index);
        return statement;
    }

    public static PreparedStatement cleanGaps(Connection connection, EventSchema schema, SortedSet<Long> gaps) throws SQLException {
        String sql = "SELECT " + schema.globalIndexColumn() + ", " + schema.timestampColumn() + " FROM " + schema.domainEventTable() + " WHERE " + schema.globalIndexColumn() + " >= ? AND " + schema.globalIndexColumn() + " <= ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setLong(1, gaps.first());
        statement.setLong(2, gaps.last() + 1L);
        return statement;
    }

    public static PreparedStatement readEventDataForAggregate(Connection connection, EventSchema schema, String identifier, long firstSequenceNumber, int batchSize) throws SQLException {
        String sql = "SELECT " + schema.trackedEventFields() + " FROM " + schema.domainEventTable() + " WHERE " + schema.aggregateIdentifierColumn() + " = ? AND " + schema.sequenceNumberColumn() + " >= ? AND " + schema.sequenceNumberColumn() + " < ? ORDER BY " + schema.sequenceNumberColumn() + " ASC";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, identifier);
        statement.setLong(2, firstSequenceNumber);
        statement.setLong(3, firstSequenceNumber + (long)batchSize);
        return statement;
    }

    public static PreparedStatement readSnapshotData(Connection connection, EventSchema schema, String identifier) throws SQLException {
        String sql = "SELECT " + schema.domainEventFields() + " FROM " + schema.snapshotTable() + " WHERE " + schema.aggregateIdentifierColumn() + " = ? ORDER BY " + schema.sequenceNumberColumn() + " DESC";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, identifier);
        return statement;
    }

    public static PreparedStatement readEventDataWithoutGaps(Connection connection, EventSchema schema, long globalIndex, int batchSize) throws SQLException {
        String sql = "SELECT " + schema.trackedEventFields() + " FROM " + schema.domainEventTable() + " WHERE (" + schema.globalIndexColumn() + " > ? AND " + schema.globalIndexColumn() + " <= ?) ORDER BY " + schema.globalIndexColumn() + " ASC";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setLong(1, globalIndex);
        statement.setLong(2, globalIndex + (long)batchSize);
        return statement;
    }

    public static PreparedStatement readEventDataWithGaps(Connection connection, EventSchema schema, long globalIndex, int batchSize, List<Long> gaps) throws SQLException {
        Integer gapSize = gaps.size();
        String sql = "SELECT " + schema.trackedEventFields() + " FROM " + schema.domainEventTable() + " WHERE (" + schema.globalIndexColumn() + " > ? AND " + schema.globalIndexColumn() + " <= ?) OR " + schema.globalIndexColumn() + " IN (" + String.join((CharSequence)",", Collections.nCopies(gapSize, "?")) + ") ORDER BY " + schema.globalIndexColumn() + " ASC";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setLong(1, globalIndex);
        statement.setLong(2, globalIndex + (long)batchSize);
        for (int i = 0; i < gapSize; ++i) {
            statement.setLong(i + 3, gaps.get(i));
        }
        return statement;
    }
}

