/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import com.lmax.disruptor.RingBuffer;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.disruptor.commandhandling.AggregateBlacklistedException;
import org.axonframework.disruptor.commandhandling.AggregateStateCorruptedException;
import org.axonframework.disruptor.commandhandling.CommandHandlingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistDetectingCallback<C, R>
implements CommandCallback<C, R> {
    private static final Logger logger = LoggerFactory.getLogger(BlacklistDetectingCallback.class);
    private final CommandCallback<? super C, R> delegate;
    private final RingBuffer<CommandHandlingEntry> ringBuffer;
    private final BiConsumer<CommandMessage<? extends C>, CommandCallback<? super C, R>> retryMethod;
    private final boolean rescheduleOnCorruptState;

    public BlacklistDetectingCallback(CommandCallback<? super C, R> delegate, RingBuffer<CommandHandlingEntry> ringBuffer, BiConsumer<CommandMessage<? extends C>, CommandCallback<? super C, R>> retryMethod, boolean rescheduleOnCorruptState) {
        this.delegate = delegate;
        this.ringBuffer = ringBuffer;
        this.retryMethod = retryMethod;
        this.rescheduleOnCorruptState = rescheduleOnCorruptState;
    }

    public void onResult(CommandMessage<? extends C> commandMessage, CommandResultMessage<? extends R> commandResultMessage) {
        if (!commandResultMessage.isExceptional()) {
            if (this.delegate != null) {
                this.delegate.onResult(commandMessage, commandResultMessage);
            }
        } else {
            Throwable cause = commandResultMessage.exceptionResult();
            if (cause instanceof AggregateBlacklistedException) {
                long sequence = this.ringBuffer.next();
                CommandHandlingEntry event = (CommandHandlingEntry)((Object)this.ringBuffer.get(sequence));
                event.resetAsRecoverEntry(((AggregateBlacklistedException)((Object)cause)).getAggregateIdentifier());
                this.ringBuffer.publish(sequence);
                if (this.delegate != null) {
                    this.delegate.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)cause.getCause()));
                }
            } else if (this.rescheduleOnCorruptState && cause instanceof AggregateStateCorruptedException) {
                this.retryMethod.accept(commandMessage, this.delegate);
            } else if (this.delegate != null) {
                this.delegate.onResult(commandMessage, commandResultMessage);
            } else {
                logger.warn("Command {} resulted in an exception:", (Object)commandMessage.getPayloadType().getSimpleName(), (Object)cause);
            }
        }
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }
}

