/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.avro;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.conversion.ConversionException;
import org.axonframework.conversion.avro.AvroConverterStrategy;
import org.axonframework.conversion.avro.AvroConverterStrategyConfiguration;
import org.axonframework.conversion.avro.AvroUtil;
import org.axonframework.conversion.avro.SchemaIncompatibilityChecker;

public class SpecificRecordBaseConverterStrategy
implements AvroConverterStrategy {
    private final SchemaStore schemaStore;
    private final SchemaIncompatibilityChecker schemaIncompatibilityChecker;
    private AvroConverterStrategyConfiguration config = AvroConverterStrategyConfiguration.DEFAULT;

    public SpecificRecordBaseConverterStrategy(@Nonnull SchemaStore schemaStore, @Nonnull SchemaIncompatibilityChecker schemaIncompatibilityChecker) {
        this.schemaStore = Objects.requireNonNull(schemaStore, "Schema store must not be null.");
        this.schemaIncompatibilityChecker = Objects.requireNonNull(schemaIncompatibilityChecker, "SchemaIncompatibilityChecker must not be null.");
    }

    @Override
    @Nonnull
    public byte[] convertToSingleObjectEncoded(@Nonnull Object object) {
        byte[] bytes;
        if (!(object instanceof SpecificRecordBase)) {
            throw new ConversionException("Expected object to be instance of SpecificRecordBase but it was " + object.getClass().getCanonicalName());
        }
        SpecificRecordBase record = (SpecificRecordBase)object;
        BinaryMessageEncoder encoder = new BinaryMessageEncoder((GenericData)record.getSpecificData(), record.getSchema());
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            encoder.encode((Object)record, (OutputStream)outputStream);
            bytes = outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new ConversionException("Failed to convert specific record", e);
        }
        return bytes;
    }

    @Override
    @Nonnull
    public <T> T convertFromSingleObjectEncoded(@Nonnull byte[] bytes, @Nonnull Class<T> readerType) {
        if (!this.test(readerType)) {
            throw new ConversionException("Expected reader type to be assignable from SpecificRecordBase but it was " + readerType.getCanonicalName());
        }
        Class<SpecificRecordBase> specificRecordBaseClass = readerType;
        long fingerprint = AvroUtil.fingerprint(bytes);
        Schema writerSchema = this.schemaStore.findByFingerprint(fingerprint);
        if (writerSchema == null) {
            throw AvroUtil.createExceptionNoSchemaFound(readerType, fingerprint);
        }
        SpecificData readerSpecificData = SpecificData.getForClass(specificRecordBaseClass);
        Schema readerSchema = AvroUtil.getClassSchemaChecked(specificRecordBaseClass);
        if (this.config.performAvroCompatibilityCheck()) {
            this.schemaIncompatibilityChecker.assertSchemaCompatibility(readerType, readerSchema, writerSchema, this.config.includeSchemasInStackTraces());
        }
        BinaryMessageDecoder decoder = new BinaryMessageDecoder((GenericData)readerSpecificData, readerSchema);
        decoder.addSchema(writerSchema);
        try {
            return (T)decoder.decode(bytes);
        }
        catch (IOException | AvroRuntimeException e) {
            throw AvroUtil.createExceptionFailedToDeserialize(readerType, readerSchema, writerSchema, (Exception)e, this.config.includeSchemasInStackTraces());
        }
    }

    @Override
    @Nonnull
    public <T> T convertFromGenericRecord(@Nonnull GenericRecord genericRecord, @Nonnull Class<T> readerType) {
        if (!this.test(readerType)) {
            throw new ConversionException("Expected reader type to be assignable from SpecificRecordBase but it was " + readerType.getCanonicalName());
        }
        Schema writerSchema = genericRecord.getSchema();
        SpecificData readerSpecificData = SpecificData.getForClass(readerType);
        Schema readerSchema = readerSpecificData.getSchema(readerType);
        if (this.config.performAvroCompatibilityCheck()) {
            this.schemaIncompatibilityChecker.assertSchemaCompatibility(readerType, readerSchema, writerSchema, this.config.includeSchemasInStackTraces());
        }
        SpecificRecordBase decoded = (SpecificRecordBase)readerSpecificData.deepCopy(writerSchema, (Object)genericRecord);
        return (T)decoded;
    }

    @Override
    public boolean test(@Nonnull Class<?> payloadType) {
        return SpecificRecordBase.class.isAssignableFrom(payloadType);
    }

    @Override
    public void applyStrategyConfiguration(@Nonnull AvroConverterStrategyConfiguration avroConverterConfiguration) {
        BuilderUtils.assertNonNull((Object)avroConverterConfiguration, (String)"AvroConverterConfiguration must not be null");
        this.config = avroConverterConfiguration;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("avroConverterStrategyConfiguration", (Object)this.config);
        descriptor.describeProperty("schemaIncompatibilityChecker", (Object)this.schemaIncompatibilityChecker);
        descriptor.describeProperty("schemaStore", (Object)this.schemaStore);
    }
}

