/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.lang.invoke.MethodHandles;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.config.LegacyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Supplier<LegacyConfiguration> configurationSupplier;
    private final Function<LegacyConfiguration, Object> messageHandlerBuilder;
    private final BiFunction<LegacyConfiguration, Object, Registration> messageHandlerSubscriber;
    private Registration handlerRegistration;

    public MessageHandlerRegistrar(Supplier<LegacyConfiguration> configSupplier, Function<LegacyConfiguration, Object> messageHandlerBuilder, BiFunction<LegacyConfiguration, Object, Registration> messageHandlerSubscriber) {
        this.configurationSupplier = configSupplier;
        this.messageHandlerBuilder = messageHandlerBuilder;
        this.messageHandlerSubscriber = messageHandlerSubscriber;
        this.handlerRegistration = null;
    }

    public void start() {
        LegacyConfiguration config = this.configurationSupplier.get();
        Object annotatedHandler = this.messageHandlerBuilder.apply(config);
        BuilderUtils.assertNonNull((Object)annotatedHandler, (String)"AnnotatedMessageHandler may not be null");
        this.handlerRegistration = this.messageHandlerSubscriber.apply(config, annotatedHandler);
    }

    public void shutdown() {
        if (this.handlerRegistration == null) {
            logger.info("Shutting down a message handler registrar before it was started.");
            return;
        }
        this.handlerRegistration.cancel();
    }
}

