/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.SagaConfigurer;
import org.axonframework.config.SubscribableMessageSourceDefinition;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventProcessorConfiguration;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventHandlerInvoker;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.monitoring.MessageMonitor;

public interface EventProcessingConfigurer {
    default public <T> EventProcessingConfigurer registerSaga(Class<T> sagaType) {
        return this.registerSaga(sagaType, c -> {});
    }

    public <T> EventProcessingConfigurer registerSaga(Class<T> var1, Consumer<SagaConfigurer<T>> var2);

    public EventProcessingConfigurer registerSagaStore(Function<LegacyConfiguration, SagaStore> var1);

    public EventProcessingConfigurer registerEventHandler(Function<LegacyConfiguration, Object> var1);

    public EventProcessingConfigurer registerDefaultListenerInvocationErrorHandler(Function<LegacyConfiguration, ListenerInvocationErrorHandler> var1);

    public EventProcessingConfigurer registerListenerInvocationErrorHandler(String var1, Function<LegacyConfiguration, ListenerInvocationErrorHandler> var2);

    default public EventProcessingConfigurer registerTrackingEventProcessor(String name) {
        return this.registerTrackingEventProcessor(name, c -> {
            EventBus eventBus = c.eventBus();
            if (!(eventBus instanceof StreamableMessageSource)) {
                throw new AxonConfigurationException("Cannot create Tracking Event Processor with name '" + name + "'. The available EventBus does not support tracking processors.");
            }
            return (StreamableMessageSource)eventBus;
        });
    }

    public EventProcessingConfigurer configureDefaultStreamableMessageSource(Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> var1);

    public EventProcessingConfigurer configureDefaultSubscribableMessageSource(Function<LegacyConfiguration, SubscribableMessageSource<EventMessage<?>>> var1);

    public EventProcessingConfigurer registerTrackingEventProcessor(String var1, Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> var2);

    public EventProcessingConfigurer registerTrackingEventProcessor(String var1, Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> var2, Function<LegacyConfiguration, TrackingEventProcessorConfiguration> var3);

    public EventProcessingConfigurer registerEventProcessorFactory(EventProcessorBuilder var1);

    public EventProcessingConfigurer registerEventProcessor(String var1, EventProcessorBuilder var2);

    public EventProcessingConfigurer registerTokenStore(String var1, Function<LegacyConfiguration, TokenStore> var2);

    public EventProcessingConfigurer registerTokenStore(Function<LegacyConfiguration, TokenStore> var1);

    public EventProcessingConfigurer usingSubscribingEventProcessors();

    public EventProcessingConfigurer usingTrackingEventProcessors();

    public EventProcessingConfigurer usingPooledStreamingEventProcessors();

    default public EventProcessingConfigurer usingPooledStreamingEventProcessors(PooledStreamingProcessorConfiguration pooledStreamingProcessorConfiguration) {
        return this.usingPooledStreamingEventProcessors().registerPooledStreamingEventProcessorConfiguration(pooledStreamingProcessorConfiguration);
    }

    default public EventProcessingConfigurer registerSubscribingEventProcessor(String name) {
        return this.registerSubscribingEventProcessor(name, LegacyConfiguration::eventBus);
    }

    public EventProcessingConfigurer registerSubscribingEventProcessor(String var1, Function<LegacyConfiguration, SubscribableMessageSource<? extends EventMessage<?>>> var2);

    public EventProcessingConfigurer registerDefaultErrorHandler(Function<LegacyConfiguration, ErrorHandler> var1);

    public EventProcessingConfigurer registerErrorHandler(String var1, Function<LegacyConfiguration, ErrorHandler> var2);

    default public EventProcessingConfigurer byDefaultAssignTo(String processingGroup) {
        this.byDefaultAssignHandlerTypesTo(c -> processingGroup);
        return this.byDefaultAssignHandlerInstancesTo(o -> processingGroup);
    }

    public EventProcessingConfigurer byDefaultAssignHandlerInstancesTo(Function<Object, String> var1);

    public EventProcessingConfigurer byDefaultAssignHandlerTypesTo(Function<Class<?>, String> var1);

    default public EventProcessingConfigurer assignHandlerInstancesMatching(String processingGroup, Predicate<Object> criteria) {
        return this.assignHandlerInstancesMatching(processingGroup, 0, criteria);
    }

    default public EventProcessingConfigurer assignHandlerTypesMatching(String processingGroup, Predicate<Class<?>> criteria) {
        return this.assignHandlerTypesMatching(processingGroup, 0, criteria);
    }

    public EventProcessingConfigurer assignHandlerInstancesMatching(String var1, int var2, Predicate<Object> var3);

    public EventProcessingConfigurer assignHandlerTypesMatching(String var1, int var2, Predicate<Class<?>> var3);

    public EventProcessingConfigurer assignProcessingGroup(String var1, String var2);

    public EventProcessingConfigurer assignProcessingGroup(Function<String, String> var1);

    public EventProcessingConfigurer registerHandlerInterceptor(String var1, Function<LegacyConfiguration, MessageHandlerInterceptor<? super EventMessage<?>>> var2);

    public EventProcessingConfigurer registerDefaultHandlerInterceptor(BiFunction<LegacyConfiguration, String, MessageHandlerInterceptor<? super EventMessage<?>>> var1);

    public EventProcessingConfigurer registerSequencingPolicy(String var1, Function<LegacyConfiguration, SequencingPolicy<? super EventMessage<?>>> var2);

    public EventProcessingConfigurer registerDefaultSequencingPolicy(Function<LegacyConfiguration, SequencingPolicy<? super EventMessage<?>>> var1);

    default public EventProcessingConfigurer registerMessageMonitor(String eventProcessorName, Function<LegacyConfiguration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.registerMessageMonitorFactory(eventProcessorName, (configuration, componentType, componentName) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public EventProcessingConfigurer registerMessageMonitorFactory(String var1, MessageMonitorFactory var2);

    public EventProcessingConfigurer registerTransactionManager(String var1, Function<LegacyConfiguration, TransactionManager> var2);

    public EventProcessingConfigurer registerDefaultTransactionManager(Function<LegacyConfiguration, TransactionManager> var1);

    public EventProcessingConfigurer registerTrackingEventProcessorConfiguration(String var1, Function<LegacyConfiguration, TrackingEventProcessorConfiguration> var2);

    public EventProcessingConfigurer registerTrackingEventProcessorConfiguration(Function<LegacyConfiguration, TrackingEventProcessorConfiguration> var1);

    default public EventProcessingConfigurer registerPooledStreamingEventProcessor(String name) {
        return this.registerPooledStreamingEventProcessor(name, c -> {
            EventBus eventBus = c.eventBus();
            if (!(eventBus instanceof StreamableMessageSource)) {
                throw new AxonConfigurationException("Cannot create Pooled Streaming Event Processor with name '" + name + "'. The available EventBus does not support tracking processors.");
            }
            return (StreamableMessageSource)eventBus;
        });
    }

    default public EventProcessingConfigurer registerPooledStreamingEventProcessor(String name, Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> messageSource) {
        return this.registerPooledStreamingEventProcessor(name, messageSource, PooledStreamingProcessorConfiguration.noOp());
    }

    public EventProcessingConfigurer registerPooledStreamingEventProcessor(String var1, Function<LegacyConfiguration, StreamableMessageSource<TrackedEventMessage<?>>> var2, PooledStreamingProcessorConfiguration var3);

    public EventProcessingConfigurer registerPooledStreamingEventProcessorConfiguration(PooledStreamingProcessorConfiguration var1);

    public EventProcessingConfigurer registerPooledStreamingEventProcessorConfiguration(String var1, PooledStreamingProcessorConfiguration var2);

    default public EventProcessingConfigurer registerDeadLetterQueue(@Nonnull String processingGroup, @Nonnull Function<LegacyConfiguration, SequencedDeadLetterQueue<EventMessage<?>>> queueBuilder) {
        return this;
    }

    default public EventProcessingConfigurer registerDefaultDeadLetterPolicy(@Nonnull Function<LegacyConfiguration, EnqueuePolicy<EventMessage<?>>> policyBuilder) {
        return this;
    }

    default public EventProcessingConfigurer registerDeadLetterPolicy(@Nonnull String processingGroup, @Nonnull Function<LegacyConfiguration, EnqueuePolicy<EventMessage<?>>> policyBuilder) {
        return this;
    }

    default public EventProcessingConfigurer registerDeadLetteringEventHandlerInvokerConfiguration(@Nonnull String processingGroup, @Nonnull DeadLetteringInvokerConfiguration configuration) {
        return this;
    }

    default public EventProcessingConfigurer registerDeadLetterQueueProvider(Function<String, Function<LegacyConfiguration, SequencedDeadLetterQueue<EventMessage<?>>>> deadLetterQueueProvider) {
        return this;
    }

    default public EventProcessingConfigurer usingSubscribingEventProcessors(SubscribableMessageSourceDefinitionBuilder builder) {
        return this;
    }

    @FunctionalInterface
    public static interface PooledStreamingProcessorConfiguration
    extends BiFunction<LegacyConfiguration, PooledStreamingEventProcessor.Builder, PooledStreamingEventProcessor.Builder> {
        default public PooledStreamingProcessorConfiguration andThen(PooledStreamingProcessorConfiguration other) {
            return (config, builder) -> (PooledStreamingEventProcessor.Builder)other.apply(config, (PooledStreamingEventProcessor.Builder)this.apply(config, builder));
        }

        public static PooledStreamingProcessorConfiguration noOp() {
            return (config, builder) -> builder;
        }
    }

    @FunctionalInterface
    public static interface SubscribableMessageSourceDefinitionBuilder {
        public SubscribableMessageSourceDefinition<EventMessage<?>> build(String var1);
    }

    @FunctionalInterface
    public static interface DeadLetteringInvokerConfiguration
    extends BiFunction<LegacyConfiguration, DeadLetteringEventHandlerInvoker.Builder, DeadLetteringEventHandlerInvoker.Builder> {
        default public DeadLetteringInvokerConfiguration andThen(DeadLetteringInvokerConfiguration other) {
            return (config, builder) -> (DeadLetteringEventHandlerInvoker.Builder)other.apply(config, (DeadLetteringEventHandlerInvoker.Builder)this.apply(config, builder));
        }

        public static DeadLetteringInvokerConfiguration noOp() {
            return (config, builder) -> builder;
        }
    }

    @FunctionalInterface
    public static interface EventProcessorBuilder {
        public EventProcessor build(String var1, LegacyConfiguration var2, EventHandlerInvoker var3);
    }
}

