/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.config.LegacyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Component<B> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final Supplier<LegacyConfiguration> configSupplier;
    private Function<LegacyConfiguration, ? extends B> builderFunction;
    private B instance;

    public Component(LegacyConfiguration config, String name, Function<LegacyConfiguration, ? extends B> builderFunction) {
        this(() -> config, name, builderFunction);
    }

    public Component(@Nonnull Supplier<LegacyConfiguration> config, @Nonnull String name, @Nonnull Function<LegacyConfiguration, ? extends B> builderFunction) {
        this.configSupplier = config;
        this.name = name;
        this.builderFunction = builderFunction;
    }

    public B get() {
        if (this.instance == null) {
            LegacyConfiguration configuration = this.configSupplier.get();
            this.instance = this.builderFunction.apply(configuration);
            logger.debug("Instantiated component [{}]: {}", (Object)this.name, this.instance);
        }
        return this.instance;
    }

    public void update(@Nonnull Function<LegacyConfiguration, ? extends B> builderFunction) {
        Assert.state((this.instance == null ? 1 : 0) != 0, () -> "Cannot change " + this.name + ": it is already in use");
        this.builderFunction = builderFunction;
    }

    public boolean isInitialized() {
        return this.instance != null;
    }
}

