/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.concurrent.CompletableFuture;
import org.axonframework.config.LifecycleHandler;

public interface LifecycleOperations {
    default public void onStart(Runnable startHandler) {
        this.onStart(0, startHandler);
    }

    default public void onStart(int phase, Runnable startHandler) {
        this.onStart(phase, () -> {
            try {
                startHandler.run();
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                CompletableFuture exceptionResult = new CompletableFuture();
                exceptionResult.completeExceptionally(e);
                return exceptionResult;
            }
        });
    }

    public void onStart(int var1, LifecycleHandler var2);

    default public void onShutdown(Runnable shutdownHandler) {
        this.onShutdown(0, shutdownHandler);
    }

    default public void onShutdown(int phase, Runnable shutdownHandler) {
        this.onShutdown(phase, () -> {
            try {
                shutdownHandler.run();
                return CompletableFuture.completedFuture(null);
            }
            catch (Exception e) {
                CompletableFuture exceptionResult = new CompletableFuture();
                exceptionResult.completeExceptionally(e);
                return exceptionResult;
            }
        });
    }

    public void onShutdown(int var1, LifecycleHandler var2);
}

