/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import jakarta.annotation.Nonnull;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.updates.LoggingUpdateCheckerReporter;
import org.axonframework.updates.UpdateChecker;
import org.axonframework.updates.UpdateCheckerHttpClient;
import org.axonframework.updates.UpdateCheckerReporter;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.axonframework.updates.detection.TestEnvironmentDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerConfigurerModule
implements ConfigurerModule {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerConfigurerModule.class);

    @Override
    public void configureModule(@Nonnull Configurer configurer) {
        if (TestEnvironmentDetector.isTestEnvironment()) {
            logger.debug("Skipping AxonIQ UpdateChecker as a testsuite environment was detected.");
            return;
        }
        configurer.registerComponent(UsagePropertyProvider.class, c -> UsagePropertyProvider.create((UsagePropertyProvider[])new UsagePropertyProvider[0])).registerComponent(UpdateCheckerHttpClient.class, c -> {
            UsagePropertyProvider propertyProvider = c.getComponent(UsagePropertyProvider.class);
            return new UpdateCheckerHttpClient(propertyProvider);
        }).registerComponent(UpdateCheckerReporter.class, c -> new LoggingUpdateCheckerReporter()).registerComponent(UpdateChecker.class, c -> new UpdateChecker(c.getComponent(UpdateCheckerHttpClient.class), c.getComponent(UpdateCheckerReporter.class), c.getComponent(UsagePropertyProvider.class)));
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }
}

