/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.annotation.Nullable;
import org.axonframework.config.Configuration;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.util.MavenArtifactVersionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonIQConsoleModule
implements ModuleConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DISABLE_CONSOLE_MESSAGE_SYSTEM_PROPERTY = "disable-axoniq-console-message";
    private static final String CONSOLE_CLIENT_MISSING_MESSAGE = "\n################################################################################################\n## You have not configured AxonIQ Console. AxonIQ Console provides out-of-the box monitoring  ##\n## and management capabilities for your Axon Application, starting with it is free.           ##\n## Visit https://console.axoniq.io for more information!                                      ##\n## Suppress this message by setting system property disable-axoniq-console-message to true.   ##\n################################################################################################\n";

    @Override
    public void initialize(Configuration config) {
        this.maybeLogConsoleIsAvailable();
    }

    private void maybeLogConsoleIsAvailable() {
        if (this.consoleMessageEnabled()) {
            String consoleClientVersion = this.consoleClientVersion();
            if (Objects.isNull(consoleClientVersion)) {
                logger.info(CONSOLE_CLIENT_MISSING_MESSAGE);
            } else {
                logger.trace("Found version {} for console-framework-client.", (Object)consoleClientVersion);
            }
        }
    }

    @Nullable
    private String consoleClientVersion() {
        String version;
        MavenArtifactVersionResolver resolver = new MavenArtifactVersionResolver("io.axoniq.console", "console-framework-client", DefaultConfigurer.class.getClassLoader());
        try {
            version = resolver.get();
        }
        catch (IOException e) {
            return null;
        }
        return version;
    }

    private boolean consoleMessageEnabled() {
        String disableConsoleMessageSystemProperty = System.getProperty(DISABLE_CONSOLE_MESSAGE_SYSTEM_PROPERTY);
        return !Boolean.TRUE.toString().equalsIgnoreCase(disableConsoleMessageSystemProperty);
    }
}

