/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.lang.invoke.MethodHandles;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.config.Configuration;
import org.axonframework.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerRegistrar
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Supplier<Configuration> configurationSupplier;
    private final Function<Configuration, Object> messageHandlerBuilder;
    private final BiFunction<Configuration, Object, Registration> messageHandlerSubscriber;
    private Registration handlerRegistration;

    public MessageHandlerRegistrar(Supplier<Configuration> configSupplier, Function<Configuration, Object> messageHandlerBuilder, BiFunction<Configuration, Object, Registration> messageHandlerSubscriber) {
        this.configurationSupplier = configSupplier;
        this.messageHandlerBuilder = messageHandlerBuilder;
        this.messageHandlerSubscriber = messageHandlerSubscriber;
        this.handlerRegistration = null;
    }

    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry handle) {
        handle.onStart(0, this::start);
        handle.onShutdown(0, this::shutdown);
    }

    public void start() {
        Configuration config = this.configurationSupplier.get();
        Object annotatedHandler = this.messageHandlerBuilder.apply(config);
        BuilderUtils.assertNonNull((Object)annotatedHandler, (String)"AnnotatedMessageHandler may not be null");
        this.handlerRegistration = this.messageHandlerSubscriber.apply(config, annotatedHandler);
    }

    public void shutdown() {
        if (this.handlerRegistration == null) {
            logger.info("Shutting down a message handler registrar before it was started.");
            return;
        }
        this.handlerRegistration.cancel();
    }
}

