/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.LifecycleOperations;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.repository.NoResourceInjector;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.tracing.SpanFactory;

public interface Configuration
extends LifecycleOperations {
    default public EventBus eventBus() {
        return this.getComponent(EventBus.class);
    }

    default public Lifecycle.LifecycleRegistry lifecycleRegistry() {
        return new Lifecycle.LifecycleRegistry(){

            public void onStart(int phase, @Nonnull Lifecycle.LifecycleHandler action) {
                Configuration.this.onStart(phase, () -> ((Lifecycle.LifecycleHandler)action).run());
            }

            public void onShutdown(int phase, @Nonnull Lifecycle.LifecycleHandler action) {
                Configuration.this.onShutdown(phase, () -> ((Lifecycle.LifecycleHandler)action).run());
            }
        };
    }

    default public EventStore eventStore() {
        EventBus eventBus = this.eventBus();
        if (!(eventBus instanceof EventStore)) {
            throw new AxonConfigurationException("A component is requesting an Event Store, however, there is none configured");
        }
        return (EventStore)eventBus;
    }

    default public <T extends ModuleConfiguration> List<T> findModules(@Nonnull Class<T> moduleType) {
        return this.getModules().stream().filter(m -> m.isType(moduleType)).map(m -> m.unwrap()).collect(Collectors.toList());
    }

    default public CommandBus commandBus() {
        return this.getComponent(CommandBus.class);
    }

    default public QueryBus queryBus() {
        return this.getComponent(QueryBus.class);
    }

    default public QueryUpdateEmitter queryUpdateEmitter() {
        return this.getComponent(QueryUpdateEmitter.class);
    }

    default public ResourceInjector resourceInjector() {
        return this.getComponent(ResourceInjector.class, () -> NoResourceInjector.INSTANCE);
    }

    default public CommandGateway commandGateway() {
        return this.getComponent(CommandGateway.class);
    }

    default public EventProcessingConfiguration eventProcessingConfiguration() throws AxonConfigurationException {
        List eventProcessingModules = this.getModules().stream().filter(module -> module.isType(EventProcessingConfiguration.class)).map(module -> (EventProcessingConfiguration)((Object)module.unwrap())).collect(Collectors.toList());
        switch (eventProcessingModules.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (EventProcessingConfiguration)eventProcessingModules.get(0);
            }
        }
        throw new AxonConfigurationException("There are several EventProcessingConfigurations defined. Use findModules(Class<T>) method instead.");
    }

    default public QueryGateway queryGateway() {
        return this.getComponent(QueryGateway.class);
    }

    default public EventGateway eventGateway() {
        return this.getComponent(EventGateway.class);
    }

    default public TagsConfiguration tags() {
        return this.getComponent(TagsConfiguration.class);
    }

    default public SpanFactory spanFactory() {
        return this.getComponent(SpanFactory.class);
    }

    default public <A> AggregateConfiguration<A> aggregateConfiguration(@Nonnull Class<A> aggregateType) {
        return this.findModules(AggregateConfiguration.class).stream().filter(aggregateConfig -> aggregateConfig.aggregateType().isAssignableFrom(aggregateType)).findFirst().map(moduleConfig -> moduleConfig).orElseThrow(() -> new IllegalArgumentException("Aggregate " + aggregateType.getSimpleName() + " has not been configured"));
    }

    default public <A> Repository<A> repository(@Nonnull Class<A> aggregateType) {
        return this.aggregateConfiguration(aggregateType).repository();
    }

    default public <A> AggregateFactory<A> aggregateFactory(@Nonnull Class<A> aggregateType) {
        return this.aggregateConfiguration(aggregateType).aggregateFactory();
    }

    default public <T> T getComponent(@Nonnull Class<T> componentType) {
        return (T)this.getComponent(componentType, () -> null);
    }

    public <T> T getComponent(@Nonnull Class<T> var1, @Nonnull Supplier<T> var2);

    public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(@Nonnull Class<?> var1, @Nonnull String var2);

    default public Serializer serializer() {
        return this.getComponent(Serializer.class);
    }

    public Serializer eventSerializer();

    public Serializer messageSerializer();

    public void start();

    public void shutdown();

    public List<CorrelationDataProvider> correlationDataProviders();

    default public ParameterResolverFactory parameterResolverFactory() {
        return this.getComponent(ParameterResolverFactory.class);
    }

    public HandlerDefinition handlerDefinition(Class<?> var1);

    default public EventScheduler eventScheduler() {
        return this.getComponent(EventScheduler.class);
    }

    default public DeadlineManager deadlineManager() {
        return this.getComponent(DeadlineManager.class);
    }

    default public Snapshotter snapshotter() {
        return this.getComponent(Snapshotter.class);
    }

    default public ScopeAwareProvider scopeAwareProvider() {
        return this.getComponent(ScopeAwareProvider.class);
    }

    public List<ModuleConfiguration> getModules();

    public EventUpcasterChain upcasterChain();

    default public SnapshotFilter snapshotFilter() {
        return this.findModules(AggregateConfiguration.class).stream().map(AggregateConfiguration::snapshotFilter).reduce(SnapshotFilter.allowAll(), SnapshotFilter::combine);
    }
}

