/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.Registration;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.disruptor.commandhandling.DisruptorCommandBus;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.modelling.command.AggregateAnnotationCommandHandler;
import org.axonframework.modelling.command.AnnotationCommandTargetResolver;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.GenericJpaRepository;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.inspection.AggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;

public class AggregateConfigurer<A>
implements AggregateConfiguration<A> {
    private final Class<A> aggregate;
    private final Component<AggregateAnnotationCommandHandler> commandHandler;
    private final Component<Repository<A>> repository;
    private final Component<AggregateFactory<A>> aggregateFactory;
    private final Component<SnapshotTriggerDefinition> snapshotTriggerDefinition;
    private final Component<CommandTargetResolver> commandTargetResolver;
    private final Component<AggregateModel<A>> metaModel;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private Configuration parent;

    protected AggregateConfigurer(Class<A> aggregate) {
        this.aggregate = aggregate;
        this.metaModel = new Component<AggregateModel>(() -> this.parent, "aggregateMetaModel<" + aggregate.getSimpleName() + ">", c -> c.getComponent(AggregateMetaModelFactory.class, () -> new AnnotatedAggregateMetaModelFactory(c.parameterResolverFactory(), c.handlerDefinition(aggregate))).createModel(aggregate));
        this.commandTargetResolver = new Component<CommandTargetResolver>(() -> this.parent, this.name("commandTargetResolver"), c -> c.getComponent(CommandTargetResolver.class, AnnotationCommandTargetResolver::new));
        this.snapshotTriggerDefinition = new Component<SnapshotTriggerDefinition>(() -> this.parent, this.name("snapshotTriggerDefinition"), c -> NoSnapshotTriggerDefinition.INSTANCE);
        this.aggregateFactory = new Component<AggregateFactory>(() -> this.parent, this.name("aggregateFactory"), c -> new GenericAggregateFactory(aggregate));
        this.repository = new Component<Repository>(() -> this.parent, "Repository<" + aggregate.getSimpleName() + ">", c -> {
            Assert.state((boolean)(c.eventBus() instanceof EventStore), () -> "Default configuration requires the use of event sourcing. Either configure an Event Store to use, or configure a specific repository implementation for " + aggregate.toString());
            if (c.commandBus() instanceof DisruptorCommandBus) {
                return ((DisruptorCommandBus)c.commandBus()).createRepository(c.eventStore(), this.aggregateFactory.get(), this.snapshotTriggerDefinition.get(), c.parameterResolverFactory(), c.handlerDefinition(aggregate), c::repository);
            }
            return EventSourcingRepository.builder((Class)aggregate).aggregateModel(this.metaModel.get()).aggregateFactory(this.aggregateFactory.get()).eventStore(c.eventStore()).snapshotTriggerDefinition(this.snapshotTriggerDefinition.get()).repositoryProvider(c::repository).build();
        });
        this.commandHandler = new Component<AggregateAnnotationCommandHandler>(() -> this.parent, "aggregateCommandHandler<" + aggregate.getSimpleName() + ">", c -> AggregateAnnotationCommandHandler.builder().repository(this.repository.get()).commandTargetResolver(this.commandTargetResolver.get()).aggregateModel(this.metaModel.get()).build());
    }

    public static <A> AggregateConfigurer<A> defaultConfiguration(Class<A> aggregateType) {
        return new AggregateConfigurer<A>(aggregateType);
    }

    public static <A> AggregateConfigurer<A> jpaMappedConfiguration(Class<A> aggregateType) {
        AggregateConfigurer<A> configurer = new AggregateConfigurer<A>(aggregateType);
        return configurer.configureRepository(c -> {
            EntityManagerProvider entityManagerProvider = c.getComponent(EntityManagerProvider.class, () -> {
                throw new AxonConfigurationException(String.format("JPA has not been correctly configured for aggregate [%s]. Either provide an EntityManagerProvider, or use DefaultConfigurer.jpaConfiguration(...) to define one for the entire configuration.", aggregateType.getSimpleName()));
            });
            return GenericJpaRepository.builder((Class)aggregateType).aggregateModel(configurer.metaModel.get()).entityManagerProvider(entityManagerProvider).eventBus(c.eventBus()).repositoryProvider(c::repository).build();
        });
    }

    public static <A> AggregateConfigurer<A> jpaMappedConfiguration(Class<A> aggregateType, EntityManagerProvider entityManagerProvider) {
        AggregateConfigurer<A> configurer = new AggregateConfigurer<A>(aggregateType);
        return configurer.configureRepository(c -> GenericJpaRepository.builder((Class)aggregateType).aggregateModel(configurer.metaModel.get()).entityManagerProvider(entityManagerProvider).eventBus(c.eventBus()).repositoryProvider(c::repository).build());
    }

    private String name(String prefix) {
        return prefix + "<" + this.aggregate.getSimpleName() + ">";
    }

    public AggregateConfigurer<A> configureRepository(Function<Configuration, Repository<A>> repositoryBuilder) {
        this.repository.update(repositoryBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureAggregateFactory(Function<Configuration, AggregateFactory<A>> aggregateFactoryBuilder) {
        this.aggregateFactory.update(aggregateFactoryBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureCommandHandler(Function<Configuration, AggregateAnnotationCommandHandler> aggregateCommandHandlerBuilder) {
        this.commandHandler.update(aggregateCommandHandlerBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureCommandTargetResolver(Function<Configuration, CommandTargetResolver> commandTargetResolverBuilder) {
        this.commandTargetResolver.update(commandTargetResolverBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureSnapshotTrigger(Function<Configuration, SnapshotTriggerDefinition> snapshotTriggerDefinition) {
        this.snapshotTriggerDefinition.update(snapshotTriggerDefinition);
        return this;
    }

    @Override
    public void initialize(Configuration parent) {
        this.parent = parent;
    }

    @Override
    public void start() {
        this.registrations.add(this.commandHandler.get().subscribe(this.parent.commandBus()));
    }

    @Override
    public void shutdown() {
        this.registrations.forEach(Registration::cancel);
        this.registrations.clear();
    }

    @Override
    public Repository<A> repository() {
        return this.repository.get();
    }

    @Override
    public Class<A> aggregateType() {
        return this.aggregate;
    }
}

