/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.TypeReflectionUtils;

public final class ReflectionUtils {
    private static final Map<Type, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final String UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE = "Unsupported member type [%s]";
    public static final boolean RECURSIVE = true;
    public static final boolean NOT_RECURSIVE = false;

    public static <R> R getFieldValue(@Nonnull Field field, @Nonnull Object object) {
        ReflectionUtils.ensureAccessible(field);
        try {
            return (R)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("Unable to access field for getting.", ex);
        }
    }

    public static <T> void setFieldValue(@Nonnull Field field, @Nonnull Object object, @Nonnull T value) {
        ReflectionUtils.ensureAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unable to access field for setting.", ex);
        }
    }

    @Nullable
    public static Class<?> declaringClass(@Nonnull Class<?> instanceClass, @Nonnull String methodName, Class<?> ... parameterTypes) {
        try {
            return instanceClass.getMethod(methodName, parameterTypes).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasEqualsMethod(@Nonnull Class<?> type) {
        return !Object.class.equals(ReflectionUtils.declaringClass(type, "equals", Object.class));
    }

    public static boolean explicitlyUnequal(@Nullable Object value, @Nullable Object otherValue) {
        if (Objects.equals(value, otherValue)) {
            return false;
        }
        if (value == null || otherValue == null) {
            return true;
        }
        if (value instanceof Comparable) {
            return ((Comparable)value).compareTo(otherValue) != 0;
        }
        if (ReflectionUtils.hasEqualsMethod(value.getClass())) {
            return !value.equals(otherValue);
        }
        return false;
    }

    @Nonnull
    public static <T extends AccessibleObject> T ensureAccessible(@Nonnull T member) {
        if (!ReflectionUtils.isAccessible(member)) {
            member.setAccessible(true);
        }
        return member;
    }

    public static boolean isAccessible(AccessibleObject member) {
        return member.isAccessible() || member instanceof Member && ReflectionUtils.isNonFinalPublicMember((Member)((Object)member));
    }

    public static boolean isNonFinalPublicMember(@Nonnull Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers()) && !Modifier.isFinal(member.getModifiers());
    }

    @Nonnull
    public static Iterable<Field> fieldsOf(@Nonnull Class<?> clazz) {
        return ReflectionUtils.fieldsOf(clazz, true);
    }

    @Nonnull
    public static Iterable<Field> fieldsOf(@Nonnull Class<?> clazz, boolean recursive) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Class<?> currentClazz = clazz;
        do {
            fields.addAll(Arrays.asList(currentClazz.getDeclaredFields()));
        } while ((currentClazz = currentClazz.getSuperclass()) != null && recursive);
        return Collections.unmodifiableList(fields);
    }

    @Nonnull
    public static Method methodOf(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterTypes);
    }

    @Nonnull
    public static Iterable<Method> methodsOf(@Nonnull Class<?> clazz) {
        return ReflectionUtils.methodsOf(clazz, true);
    }

    @Nonnull
    public static Iterable<Method> methodsOf(@Nonnull Class<?> clazz, boolean recursive) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Class<?> currentClazz = clazz;
        do {
            methods.addAll(Arrays.asList(currentClazz.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(currentClazz, methods);
        } while ((currentClazz = currentClazz.getSuperclass()) != null && recursive);
        return Collections.unmodifiableList(methods);
    }

    @Nonnull
    public static Class<?> resolvePrimitiveWrapperType(@Nonnull Class<?> primitiveType) {
        Assert.notNull(primitiveType, () -> "primitiveType may not be null");
        Assert.isTrue(primitiveType.isPrimitive(), () -> "primitiveType is not actually primitive: " + String.valueOf(primitiveType));
        Class<?> primitiveWrapperType = primitiveWrapperTypeMap.get(primitiveType);
        Assert.notNull(primitiveWrapperType, () -> "no wrapper found for primitiveType: " + String.valueOf(primitiveType));
        return primitiveWrapperType;
    }

    @Nonnull
    public static Type resolvePrimitiveWrapperTypeIfPrimitive(@Nonnull Type type) {
        Assert.notNull(type, () -> "type may not be null");
        return ObjectUtils.getOrDefault((Type)primitiveWrapperTypeMap.get(type), type);
    }

    @Nonnull
    public static Type unwrapIfType(@Nonnull Type type, Class<?> ... wrapperTypes) {
        for (Class<?> wrapperType : wrapperTypes) {
            Type wrapper = TypeReflectionUtils.getExactSuperType(type, wrapperType);
            if (wrapper instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)wrapper).getActualTypeArguments();
                if (actualTypeArguments.length != 1) continue;
                return ReflectionUtils.unwrapIfType(actualTypeArguments[0], wrapperTypes);
            }
            if (!wrapperType.equals(type)) continue;
            return Object.class;
        }
        return type;
    }

    private static void addMethodsOnDeclaredInterfaces(Class<?> currentClazz, List<Method> methods) {
        for (Class<?> iface : currentClazz.getInterfaces()) {
            methods.addAll(Arrays.asList(iface.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(iface, methods);
        }
    }

    public static boolean isTransient(@Nonnull Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    @Nonnull
    public static Optional<Class<?>> resolveGenericType(@Nonnull Field field, int genericTypeIndex) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length <= genericTypeIndex) {
            return Optional.empty();
        }
        return Optional.of((Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex]);
    }

    @Nonnull
    public static Optional<Class<?>> resolveMemberGenericType(@Nonnull Member member, int genericTypeIndex) {
        Type genericType = ReflectionUtils.getMemberGenericType(member);
        if (!(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length <= genericTypeIndex) {
            return Optional.empty();
        }
        return Optional.of((Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex]);
    }

    public static <R> R invokeAndGetMethodValue(@Nonnull Method method, @Nonnull Object object) {
        ReflectionUtils.ensureAccessible(method);
        try {
            return (R)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to access method for invocation.", ex);
        }
    }

    public static <R> R getMemberValue(@Nonnull Member member, @Nonnull Object target) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return ReflectionUtils.getFieldValue(field, target);
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return ReflectionUtils.invokeAndGetMethodValue(method, target);
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    @Nonnull
    public static Class<?> getMemberValueType(@Nonnull Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getReturnType();
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getType();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    @Nonnull
    public static Type getMemberGenericType(@Nonnull Member member) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.getGenericType();
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return method.getGenericReturnType();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    @Nonnull
    public static String getMemberGenericString(@Nonnull Member member) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return field.toGenericString();
        }
        if (member instanceof Executable) {
            Executable executable = (Executable)member;
            return executable.toGenericString();
        }
        throw new IllegalStateException(String.format(UNSUPPORTED_MEMBER_TYPE_EXCEPTION_MESSAGE, member.getClass().getName()));
    }

    @Nonnull
    public static String toDiscernibleSignature(@Nonnull Executable executable) {
        return String.format("%s(%s)", executable.getName(), Arrays.stream(executable.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",")));
    }

    @Nonnull
    public static String fieldNameFromMember(@Nonnull Member member) {
        Objects.requireNonNull(member, "The member may not be null.");
        Member member2 = member;
        Objects.requireNonNull(member2);
        Member member3 = member2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Field.class, Method.class}, (Object)member3, n)) {
            case 0: {
                Field field = (Field)member3;
                return field.getName();
            }
            case 1: {
                int prefixLength;
                Method method = (Method)member3;
                String methodName = method.getName();
                if (methodName.startsWith("get") || methodName.startsWith("set")) {
                    prefixLength = 3;
                } else if (methodName.startsWith("is")) {
                    prefixLength = 2;
                } else {
                    return methodName;
                }
                int length = methodName.length();
                if (length <= prefixLength) {
                    return methodName;
                }
                return Introspector.decapitalize(methodName.substring(prefixLength));
            }
        }
        throw new AxonConfigurationException(String.format("Member [%s] is not a field or method", member));
    }

    private ReflectionUtils() {
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperTypeMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperTypeMap.put(Character.TYPE, Character.class);
        primitiveWrapperTypeMap.put(Double.TYPE, Double.class);
        primitiveWrapperTypeMap.put(Float.TYPE, Float.class);
        primitiveWrapperTypeMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperTypeMap.put(Long.TYPE, Long.class);
        primitiveWrapperTypeMap.put(Short.TYPE, Short.class);
    }
}

