/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDecorator;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.ComponentFactory;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.DecoratorDefinition;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.OverridePolicy;
import org.axonframework.common.configuration.SearchScope;
import org.axonframework.common.infra.DescribableComponent;

public interface ComponentRegistry
extends DescribableComponent {
    default public <C> ComponentRegistry registerComponent(@Nonnull Class<C> type, @Nonnull ComponentBuilder<C> builder) {
        return this.registerComponent(ComponentDefinition.ofType(type).withBuilder(builder));
    }

    default public <C> ComponentRegistry registerComponent(@Nonnull Class<C> type, @Nullable String name, @Nonnull ComponentBuilder<? extends C> builder) {
        return this.registerComponent(ComponentDefinition.ofTypeAndName(type, name).withBuilder(builder));
    }

    public <C> ComponentRegistry registerComponent(@Nonnull ComponentDefinition<? extends C> var1);

    default public <C, D extends C> ComponentRegistry registerDecorator(@Nonnull Class<C> type, int order, @Nonnull ComponentDecorator<C, D> decorator) {
        return this.registerDecorator(DecoratorDefinition.forType(type).with(decorator).order(order));
    }

    default public <C, D extends C> ComponentRegistry registerDecorator(@Nonnull Class<C> type, @Nonnull String name, int order, @Nonnull ComponentDecorator<C, D> decorator) {
        return this.registerDecorator(DecoratorDefinition.forTypeAndName(type, name).with(decorator).order(order));
    }

    public <C> ComponentRegistry registerDecorator(@Nonnull DecoratorDefinition<C, ? extends C> var1);

    default public boolean hasComponent(@Nonnull Class<?> type) {
        return this.hasComponent(type, (String)null);
    }

    default public boolean hasComponent(@Nonnull Class<?> type, @Nonnull SearchScope searchScope) {
        return this.hasComponent(type, null, searchScope);
    }

    default public boolean hasComponent(@Nonnull Class<?> type, @Nullable String name) {
        return this.hasComponent(type, name, SearchScope.ALL);
    }

    public boolean hasComponent(@Nonnull Class<?> var1, @Nullable String var2, @Nonnull SearchScope var3);

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull Class<C> type, @Nonnull ComponentBuilder<C> builder) {
        return this.registerIfNotPresent(type, null, builder);
    }

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull Class<C> type, @Nonnull ComponentBuilder<C> builder, @Nonnull SearchScope searchScope) {
        return this.registerIfNotPresent(type, null, builder, searchScope);
    }

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull Class<C> type, @Nullable String name, @Nonnull ComponentBuilder<C> builder) {
        return this.registerIfNotPresent(ComponentDefinition.ofTypeAndName(type, name).withBuilder(builder));
    }

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull Class<C> type, @Nullable String name, @Nonnull ComponentBuilder<C> builder, @Nonnull SearchScope searchScope) {
        return this.registerIfNotPresent(ComponentDefinition.ofTypeAndName(type, name).withBuilder(builder), searchScope);
    }

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull ComponentDefinition<C> definition) {
        return definition.name() == null ? (this.hasComponent(definition.rawType()) ? this : this.registerComponent(definition)) : (this.hasComponent(definition.rawType(), definition.name()) ? this : this.registerComponent(definition));
    }

    default public <C> ComponentRegistry registerIfNotPresent(@Nonnull ComponentDefinition<C> definition, SearchScope searchScope) {
        return definition.name() == null ? (this.hasComponent(definition.rawType(), searchScope) ? this : this.registerComponent(definition)) : (this.hasComponent(definition.rawType(), definition.name(), searchScope) ? this : this.registerComponent(definition));
    }

    public ComponentRegistry registerEnhancer(@Nonnull ConfigurationEnhancer var1);

    public ComponentRegistry registerModule(@Nonnull Module var1);

    public <C> ComponentRegistry registerFactory(@Nonnull ComponentFactory<C> var1);

    public ComponentRegistry setOverridePolicy(@Nonnull OverridePolicy var1);

    public ComponentRegistry disableEnhancerScanning();

    public ComponentRegistry disableEnhancer(Class<? extends ConfigurationEnhancer> var1);

    public ComponentRegistry disableEnhancer(@Nonnull String var1);
}

