/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;

public final class FutureUtils {
    private FutureUtils() {
    }

    public static <T> Void ignoreResult(T toIgnore) {
        return null;
    }

    public static <T> CompletableFuture<T> emptyCompletedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public static <T> BiConsumer<T, Throwable> alsoComplete(CompletableFuture<T> future) {
        return (r, e) -> {
            if (e == null) {
                future.complete(r);
            } else {
                future.completeExceptionally((Throwable)e);
            }
        };
    }

    public static Throwable unwrap(Throwable exception) {
        return exception instanceof CompletionException || exception instanceof ExecutionException ? exception.getCause() : exception;
    }

    @Nullable
    public static <T> T joinAndUnwrap(@Nonnull CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            FutureUtils.sneakyThrow(e.getCause());
            return null;
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable exception) throws E {
        throw exception;
    }
}

