/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class ScalarTypeLocalDateTime
extends ScalarTypeBaseDateTime<LocalDateTime> {
    public ScalarTypeLocalDateTime(JsonConfig.DateTime mode) {
        super(mode, LocalDateTime.class, false, 93);
    }

    @Override
    public LocalDateTime convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis).toLocalDateTime();
    }

    @Override
    public long convertToMillis(LocalDateTime value) {
        return Timestamp.valueOf(value).getTime();
    }

    @Override
    protected String toJsonNanos(LocalDateTime value) {
        return String.valueOf(this.convertToMillis(value));
    }

    @Override
    protected String toJsonISO8601(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant().toString();
    }

    @Override
    public LocalDateTime convertFromTimestamp(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    @Override
    public Timestamp convertToTimestamp(LocalDateTime dateTime) {
        return Timestamp.valueOf(dateTime);
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((LocalDateTime)value);
    }

    @Override
    public LocalDateTime toBeanType(Object value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        return this.convertFromTimestamp((Timestamp)value);
    }
}

