/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareList;
import com.avaje.ebeaninternal.server.type.ModifyAwareMap;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ModifyAwareSet;
import com.avaje.ebeaninternal.server.type.PostgresHelper;
import com.avaje.ebeaninternal.server.type.ScalarHelp;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonObjectMapper {
    public static ScalarType<?> createTypeFor(boolean postgres, Class<?> type, ObjectMapper objectMapper, Type genericType, int dbType, DocPropertyType docType) {
        String pgType = ScalarTypeJsonObjectMapper.getPostgresType(postgres, dbType);
        if (Set.class.equals(type)) {
            return new OmSet(objectMapper, genericType, dbType, pgType, docType);
        }
        if (List.class.equals(type)) {
            return new OmList(objectMapper, genericType, dbType, pgType, docType);
        }
        if (Map.class.equals(type)) {
            return new OmMap(objectMapper, genericType, dbType, pgType);
        }
        return new GenericObject(objectMapper, genericType, dbType, pgType);
    }

    private static String getPostgresType(boolean postgres, int dbType) {
        if (postgres) {
            switch (dbType) {
                case 5001: {
                    return "json";
                }
                case 5002: {
                    return "jsonb";
                }
            }
        }
        return null;
    }

    private static abstract class Base<T>
    extends ScalarTypeBase<T> {
        private final ObjectMapper objectMapper;
        private final JavaType javaType;
        private final String pgType;
        private final DocPropertyType docType;

        public Base(Class<T> cls, ObjectMapper objectMapper, Type type, int dbType, String pgType, DocPropertyType docType) {
            super(cls, false, dbType);
            this.pgType = pgType;
            this.docType = docType;
            this.objectMapper = objectMapper;
            this.javaType = objectMapper.getTypeFactory().constructType(type);
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public boolean isDirty(Object value) {
            return !(value instanceof ModifyAwareOwner) || ((ModifyAwareOwner)value).isMarkedDirty();
        }

        @Override
        public T read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return (T)this.objectMapper.readValue(json, this.javaType);
            }
            catch (IOException e) {
                throw new SQLException("Unable to convert JSON", e);
            }
        }

        @Override
        public void bind(DataBind bind, T value) throws SQLException {
            if (this.pgType != null) {
                String rawJson = value == null ? null : this.formatValue(value);
                bind.setObject(PostgresHelper.asObject(this.pgType, rawJson));
            } else if (value == null) {
                bind.setNull(this.jdbcType);
            } else {
                try {
                    String json = this.objectMapper.writeValueAsString(value);
                    bind.setString(json);
                }
                catch (JsonProcessingException e) {
                    throw new SQLException("Unable to create JSON", e);
                }
            }
        }

        @Override
        public Object toJdbcType(Object value) {
            return value;
        }

        @Override
        public T toBeanType(Object value) {
            return (T)value;
        }

        @Override
        public String formatValue(T value) {
            try {
                return this.objectMapper.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new PersistenceException("Unable to create JSON", (Throwable)e);
            }
        }

        @Override
        public T parse(String value) {
            try {
                return (T)this.objectMapper.readValue(value, this.javaType);
            }
            catch (IOException e) {
                throw new PersistenceException("Unable to convert JSON", (Throwable)e);
            }
        }

        @Override
        public DocPropertyType getDocType() {
            return this.docType;
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public T convertFromMillis(long dateTime) {
            throw new IllegalStateException("Not supported");
        }

        @Override
        public T jsonRead(JsonParser parser) throws IOException {
            return (T)this.objectMapper.readValue(parser, this.javaType);
        }

        @Override
        public void jsonWrite(JsonGenerator writer, T value) throws IOException {
            this.objectMapper.writeValue(writer, value);
        }

        @Override
        public T readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        @Override
        public void writeData(DataOutput dataOutput, T value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }

    private static class OmMap
    extends Base<Map> {
        public OmMap(ObjectMapper objectMapper, Type type, int dbType, String pgType) {
            super(Map.class, objectMapper, type, dbType, pgType, DocPropertyType.OBJECT);
        }

        @Override
        public Map read(DataReader reader) throws SQLException {
            Map value = (Map)super.read(reader);
            return value == null ? null : new ModifyAwareMap(value);
        }
    }

    private static class OmList
    extends Base<List> {
        public OmList(ObjectMapper objectMapper, Type type, int dbType, String pgType, DocPropertyType docType) {
            super(List.class, objectMapper, type, dbType, pgType, docType);
        }

        @Override
        public List read(DataReader reader) throws SQLException {
            List value = (List)super.read(reader);
            return value == null ? null : new ModifyAwareList(value);
        }
    }

    private static class OmSet
    extends Base<Set> {
        public OmSet(ObjectMapper objectMapper, Type type, int dbType, String pgType, DocPropertyType docType) {
            super(Set.class, objectMapper, type, dbType, pgType, docType);
        }

        @Override
        public Set read(DataReader reader) throws SQLException {
            Set value = (Set)super.read(reader);
            return value == null ? null : new ModifyAwareSet(value);
        }
    }

    private static class GenericObject
    extends Base<Object> {
        public GenericObject(ObjectMapper objectMapper, Type type, int dbType, String pgType) {
            super(Object.class, objectMapper, type, dbType, pgType, DocPropertyType.OBJECT);
        }
    }
}

