/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ScalarHelp;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonMapPostgres;
import com.avaje.ebeaninternal.util.EncodeUtil;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;

public abstract class ScalarTypeJsonMap
extends ScalarTypeBase<Map> {
    private static final ScalarTypeJsonMap CLOB = new Clob();
    private static final ScalarTypeJsonMap BLOB = new Blob();
    private static final ScalarTypeJsonMap VARCHAR = new Varchar();
    private static final ScalarTypeJsonMap JSON = new ScalarTypeJsonMapPostgres.JSON();
    private static final ScalarTypeJsonMap JSONB = new ScalarTypeJsonMapPostgres.JSONB();

    public static ScalarTypeJsonMap typeFor(boolean postgres, int dbType) {
        switch (dbType) {
            case 12: {
                return VARCHAR;
            }
            case 2004: {
                return BLOB;
            }
            case 2005: {
                return CLOB;
            }
            case 5002: {
                return postgres ? JSONB : CLOB;
            }
            case 5001: {
                return postgres ? JSON : CLOB;
            }
        }
        throw new IllegalStateException("Unknown dbType " + dbType);
    }

    public ScalarTypeJsonMap(int jdbcType) {
        super(Map.class, false, jdbcType);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return !(value instanceof ModifyAwareOwner) || ((ModifyAwareOwner)value).isMarkedDirty();
    }

    @Override
    public Map read(DataReader dataReader) throws SQLException {
        String rawJson = dataReader.getString();
        if (rawJson == null) {
            return null;
        }
        return this.parse(rawJson);
    }

    @Override
    public void bind(DataBind b, Map value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            String rawJson = this.formatValue(value);
            b.setString(rawJson);
        }
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public Map toBeanType(Object value) {
        return (Map)value;
    }

    @Override
    public String formatValue(Map v) {
        try {
            return EJson.write(v);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map parse(String value) {
        try {
            return EJson.parseObject(value, true);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    public Map parse(Reader reader) {
        try {
            return EJson.parseObject(reader, true);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    @Override
    public void writeData(DataOutput dataOutput, Map map) throws IOException {
        if (map == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(map));
        }
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Map value) throws IOException {
        EJson.write((Object)value, writer);
    }

    @Override
    public Map jsonRead(JsonParser parser) throws IOException {
        return EJson.parseObject(parser, parser.getCurrentToken());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.OBJECT;
    }

    public static class Blob
    extends ScalarTypeJsonMap {
        public Blob() {
            super(2004);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map read(DataReader dataReader) throws SQLException {
            Map map;
            InputStream is = dataReader.getBinaryStream();
            if (is == null) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(is);
            try {
                map = this.parse(reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("Error reading Blob stream from DB", e);
                }
            }
            reader.close();
            return map;
        }

        @Override
        public void bind(DataBind b, Map value) throws SQLException {
            if (value == null) {
                b.setNull(2004);
            } else {
                String rawJson = this.formatValue(value);
                b.setBytes(EncodeUtil.utf8ToBytes(rawJson));
            }
        }
    }

    public static class Varchar
    extends ScalarTypeJsonMap {
        public Varchar() {
            super(12);
        }
    }

    public static class Clob
    extends ScalarTypeJsonMap {
        public Clob() {
            super(2005);
        }

        @Override
        public Map read(DataReader dataReader) throws SQLException {
            String content = dataReader.getStringFromStream();
            if (content == null) {
                return null;
            }
            return this.parse(content);
        }
    }
}

