/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.PostgresHelper;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonCollection;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonList {
    public static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docType) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docType);
                }
                case 5001: {
                    return new Json(docType);
                }
            }
        }
        return new Varchar(docType);
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docType) {
            super(jdbcType, docType);
            this.pgType = pgType;
        }

        @Override
        public void bind(DataBind bind, List value) throws SQLException {
            String rawJson = value == null ? null : this.formatValue(value);
            bind.setObject(PostgresHelper.asObject(this.pgType, rawJson));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<List> {
        public Base(int dbType, DocPropertyType docType) {
            super(List.class, dbType, docType);
        }

        @Override
        public List read(DataReader dataReader) throws SQLException {
            try {
                return EJson.parseList(dataReader.getString(), true);
            }
            catch (IOException e) {
                throw new SQLException("Failed to parse JSON content as List: [" + dataReader.getString() + "]", e);
            }
        }

        @Override
        public void bind(DataBind b, List value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else if (value.isEmpty()) {
                b.setString("[]");
            } else {
                try {
                    b.setString(EJson.write(value));
                }
                catch (IOException e) {
                    throw new SQLException("Failed to format List into JSON content", e);
                }
            }
        }

        @Override
        public String formatValue(List value) {
            try {
                return EJson.write(value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
            }
        }

        @Override
        public List parse(String value) {
            try {
                return EJson.parseList(value, false);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as List: [" + value + "]", (Throwable)e);
            }
        }

        @Override
        public List jsonRead(JsonParser parser) throws IOException {
            return EJson.parseList(parser, parser.getCurrentToken());
        }

        @Override
        public void jsonWrite(JsonGenerator writer, List value) throws IOException {
            EJson.write((Object)value, writer);
        }
    }

    private static class JsonB
    extends PgBase {
        public JsonB(DocPropertyType docType) {
            super(5002, "jsonb", docType);
        }
    }

    private static class Json
    extends PgBase {
        public Json(DocPropertyType docType) {
            super(5001, "json", docType);
        }
    }

    public static class Varchar
    extends Base {
        public Varchar(DocPropertyType docType) {
            super(12, docType);
        }
    }
}

