/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeInteger
extends ScalarTypeBase<Integer> {
    public ScalarTypeInteger() {
        super(Integer.class, true, 4);
    }

    @Override
    public void bind(DataBind b, Integer value) throws SQLException {
        if (value == null) {
            b.setNull(4);
        } else {
            b.setInt(value);
        }
    }

    @Override
    public Integer read(DataReader dataReader) throws SQLException {
        return dataReader.getInt();
    }

    @Override
    public Integer readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readInt();
    }

    @Override
    public void writeData(DataOutput dataOutput, Integer value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(value);
        }
    }

    @Override
    public long asVersion(Integer value) {
        return value.longValue();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toInteger(value);
    }

    @Override
    public Integer toBeanType(Object value) {
        return BasicTypeConverter.toInteger(value);
    }

    @Override
    public String formatValue(Integer v) {
        return v.toString();
    }

    @Override
    public Integer parse(String value) {
        return Integer.valueOf(value);
    }

    @Override
    public Integer convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Integer jsonRead(JsonParser parser) throws IOException {
        return parser.getIntValue();
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Integer value) throws IOException {
        writer.writeNumber(value.intValue());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.INTEGER;
    }
}

