/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;

public class ScalarTypeInstant
extends ScalarTypeBaseDateTime<Instant> {
    public ScalarTypeInstant(JsonConfig.DateTime mode) {
        super(mode, Instant.class, false, 93);
    }

    @Override
    protected String toJsonNanos(Instant value) {
        return this.toJsonNanos(value.getEpochSecond(), value.getNano());
    }

    @Override
    protected String toJsonISO8601(Instant value) {
        return value.toString();
    }

    @Override
    public long convertToMillis(Instant value) {
        return value.toEpochMilli();
    }

    @Override
    public Instant convertFromMillis(long systemTimeMillis) {
        return Instant.ofEpochMilli(systemTimeMillis);
    }

    @Override
    public Instant convertFromTimestamp(Timestamp ts) {
        return ts.toInstant();
    }

    @Override
    public Timestamp convertToTimestamp(Instant t) {
        return Timestamp.from(t);
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((Instant)value);
    }

    @Override
    public Instant toBeanType(Object value) {
        if (value instanceof Instant) {
            return (Instant)value;
        }
        return this.convertFromTimestamp((Timestamp)value);
    }
}

