/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.EnumToDbValueMap;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnum;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnumStandard;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ScalarTypeEnumWithMapping
extends ScalarTypeEnumStandard.EnumBase
implements ScalarType,
ScalarTypeEnum {
    private final EnumToDbValueMap beanDbMap;
    private final int length;

    public ScalarTypeEnumWithMapping(EnumToDbValueMap<?> beanDbMap, Class<?> enumType, int length) {
        super(enumType, false, beanDbMap.getDbType());
        this.beanDbMap = beanDbMap;
        this.length = length;
    }

    public long asVersion(Object value) {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean isBinaryType() {
        return false;
    }

    @Override
    public Set<String> getDbCheckConstraintValues() {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        Iterator it = this.beanDbMap.dbValues();
        while (it.hasNext()) {
            Object dbValue = it.next();
            if (this.beanDbMap.isIntegerType()) {
                values.add(dbValue.toString());
                continue;
            }
            values.add("'" + dbValue.toString() + "'");
        }
        return values;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void bind(DataBind b, Object value) throws SQLException {
        this.beanDbMap.bind(b, value);
    }

    @Override
    public Object read(DataReader dataReader) throws SQLException {
        return this.beanDbMap.read(dataReader);
    }

    public Object toBeanType(Object dbValue) {
        if (dbValue == null || dbValue instanceof Enum) {
            return dbValue;
        }
        return this.beanDbMap.getBeanValue(dbValue);
    }

    @Override
    public Object toJdbcType(Object beanValue) {
        return this.beanDbMap.getDbValue(beanValue);
    }
}

