/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import java.util.UUID;

public interface ArrayElementConverter<T> {
    public static final ArrayElementConverter UUID = new UuidConverter();
    public static final ArrayElementConverter STRING = new StringConverter();
    public static final ArrayElementConverter LONG = new LongConverter();
    public static final ArrayElementConverter INTEGER = new IntegerConverter();

    public T toElement(Object var1);

    public static class NoopConverter<T>
    implements ArrayElementConverter<T> {
        @Override
        public T toElement(Object rawValue) {
            return (T)rawValue;
        }
    }

    public static class UuidConverter
    extends NoopConverter<UUID> {
    }

    public static class StringConverter
    extends NoopConverter<String> {
    }

    public static class IntegerConverter
    implements ArrayElementConverter<Integer> {
        @Override
        public Integer toElement(Object rawValue) {
            if (rawValue instanceof Integer) {
                return (Integer)rawValue;
            }
            return ((Number)rawValue).intValue();
        }
    }

    public static class LongConverter
    implements ArrayElementConverter<Long> {
        @Override
        public Long toElement(Object rawValue) {
            if (rawValue instanceof Long) {
                return (Long)rawValue;
            }
            return ((Number)rawValue).longValue();
        }
    }
}

