/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cluster.BinaryMessage;
import com.avaje.ebeaninternal.server.cluster.BinaryMessageList;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BeanPersistIds {
    private final BeanDescriptor<?> beanDescriptor;
    private final String descriptorId;
    private List<Object> insertIds;
    private List<Object> updateIds;
    private List<Object> deleteIds;

    public BeanPersistIds(BeanDescriptor<?> desc) {
        this.beanDescriptor = desc;
        this.descriptorId = desc.getDescriptorId();
    }

    public static BeanPersistIds readBinaryMessage(SpiEbeanServer server, DataInput dataInput) throws IOException {
        String descriptorId = dataInput.readUTF();
        BeanDescriptor<?> desc = server.getBeanDescriptorById(descriptorId);
        BeanPersistIds bp = new BeanPersistIds(desc);
        bp.read(dataInput);
        return bp;
    }

    private void read(DataInput dataInput) throws IOException {
        IdBinder idBinder = this.beanDescriptor.getIdBinder();
        int iudType = dataInput.readInt();
        List<Object> idList = this.readIdList(dataInput, idBinder);
        switch (iudType) {
            case 0: {
                this.insertIds = idList;
                break;
            }
            case 1: {
                this.updateIds = idList;
                break;
            }
            case 2: {
                this.deleteIds = idList;
                break;
            }
            default: {
                throw new RuntimeException("Invalid iudType " + iudType);
            }
        }
    }

    void writeBinaryMessage(BinaryMessageList msgList) throws IOException {
        this.writeIdList(this.beanDescriptor, 0, this.insertIds, msgList);
        this.writeIdList(this.beanDescriptor, 1, this.updateIds, msgList);
        this.writeIdList(this.beanDescriptor, 2, this.deleteIds, msgList);
    }

    private List<Object> readIdList(DataInput dataInput, IdBinder idBinder) throws IOException {
        int count = dataInput.readInt();
        if (count < 1) {
            return null;
        }
        ArrayList<Object> idList = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            idList.add(idBinder.readData(dataInput));
        }
        return idList;
    }

    private void writeIdList(BeanDescriptor<?> desc, int iudType, List<Object> idList, BinaryMessageList msgList) throws IOException {
        int count;
        IdBinder idBinder = desc.getIdBinder();
        int n = count = idList == null ? 0 : idList.size();
        if (count > 0) {
            int loop = 0;
            int i = 0;
            int eof = idList.size();
            do {
                int endOfLoop = Math.min(eof, ++loop * 100);
                BinaryMessage m = new BinaryMessage(endOfLoop * 4 + 20);
                DataOutputStream os = m.getOs();
                os.writeInt(1);
                os.writeUTF(this.descriptorId);
                os.writeInt(iudType);
                os.writeInt(count);
                while (i < endOfLoop) {
                    idBinder.writeData(os, idList.get(i));
                    ++i;
                }
                os.flush();
                msgList.add(m);
            } while (i < eof);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.beanDescriptor != null) {
            sb.append(this.beanDescriptor.getFullName());
        } else {
            sb.append("descId:").append(this.descriptorId);
        }
        if (this.insertIds != null) {
            sb.append(" insertIds:").append(this.insertIds);
        }
        if (this.updateIds != null) {
            sb.append(" updateIds:").append(this.updateIds);
        }
        if (this.deleteIds != null) {
            sb.append(" deleteIds:").append(this.deleteIds);
        }
        return sb.toString();
    }

    void addId(PersistRequest.Type type, Serializable id) {
        switch (type) {
            case INSERT: {
                this.addInsertId(id);
                break;
            }
            case UPDATE: {
                this.addUpdateId(id);
                break;
            }
            case DELETE: 
            case SOFT_DELETE: {
                this.addDeleteId(id);
                break;
            }
        }
    }

    private void addInsertId(Serializable id) {
        if (this.insertIds == null) {
            this.insertIds = new ArrayList<Object>();
        }
        this.insertIds.add(id);
    }

    private void addUpdateId(Serializable id) {
        if (this.updateIds == null) {
            this.updateIds = new ArrayList<Object>();
        }
        this.updateIds.add(id);
    }

    private void addDeleteId(Serializable id) {
        if (this.deleteIds == null) {
            this.deleteIds = new ArrayList<Object>();
        }
        this.deleteIds.add(id);
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    List<Object> getDeleteIds() {
        return this.deleteIds;
    }

    void notifyCacheAndListener() {
        Object id;
        int i;
        this.beanDescriptor.queryCacheClear();
        if (this.updateIds != null) {
            for (i = 0; i < this.updateIds.size(); ++i) {
                id = this.updateIds.get(i);
                this.beanDescriptor.cacheHandleDeleteById(id);
            }
        }
        if (this.deleteIds != null) {
            for (i = 0; i < this.deleteIds.size(); ++i) {
                id = this.deleteIds.get(i);
                this.beanDescriptor.cacheHandleDeleteById(id);
            }
        }
    }
}

