/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OrmUpdateProperties {
    private static final NullValue NULL_VALUE = new NullValue();
    private static final NoneValue NONE_VALUE = new NoneValue();
    private LinkedHashMap<String, Value> values = new LinkedHashMap();

    public void set(String propertyName, Object value) {
        if (value == null) {
            this.values.put(propertyName, NULL_VALUE);
        } else {
            this.values.put(propertyName, new SimpleValue(value));
        }
    }

    public void setRaw(String propertyName) {
        this.values.put(propertyName, NONE_VALUE);
    }

    public void setRaw(String propertyExpression, Object ... vals) {
        if (vals.length == 0) {
            this.setRaw(propertyExpression);
        } else {
            this.values.put(propertyExpression, new RawArrayValue(vals));
        }
    }

    public boolean isSameByPlan(OrmUpdateProperties that) {
        return that.values.size() == this.values.size() && this.logicalSetClause().equals(that.logicalSetClause());
    }

    public void buildQueryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(OrmUpdateProperties.class);
        Set<Map.Entry<String, Value>> entries = this.values.entrySet();
        for (Map.Entry<String, Value> entry : entries) {
            builder.add(entry.getKey());
            builder.bind(entry.getValue().getBindCount());
        }
    }

    public void bind(Binder binder, DataBind dataBind) throws SQLException {
        for (Value bindValue : this.values.values()) {
            bindValue.bind(binder, dataBind);
        }
    }

    public String buildSetClause(DeployParser deployParser) {
        int setCount = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.values.entrySet()) {
            String property = entry.getKey();
            if (setCount++ > 0) {
                sb.append(", ");
            }
            sb.append(deployParser.parse(property).replace("${}", ""));
            sb.append(entry.getValue().bindClause());
        }
        return sb.toString();
    }

    private String logicalSetClause() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.values.entrySet()) {
            sb.append(", ");
            sb.append(entry.getKey()).append(entry.getValue().bindClause());
        }
        return sb.toString();
    }

    static class RawArrayValue
    extends Value {
        final Object[] bindValues;

        public RawArrayValue(Object[] bindValues) {
            this.bindValues = bindValues;
        }

        @Override
        public int getBindCount() {
            return this.bindValues.length;
        }

        @Override
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
            for (Object val : this.bindValues) {
                binder.bindObject(dataBind, val);
                dataBind.append(val).append(",");
            }
        }
    }

    static class NoneValue
    extends Value {
        NoneValue() {
        }

        @Override
        public String bindClause() {
            return "";
        }
    }

    static class SimpleValue
    extends Value {
        final Object value;

        SimpleValue(Object value) {
            this.value = value;
        }

        @Override
        public int getBindCount() {
            return 1;
        }

        @Override
        public String bindClause() {
            return "=?";
        }

        @Override
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
            binder.bindObject(dataBind, this.value);
            dataBind.append(this.value).append(",");
        }
    }

    static class NullValue
    extends Value {
        NullValue() {
        }

        @Override
        public String bindClause() {
            return "=null";
        }
    }

    public static abstract class Value {
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
        }

        public String bindClause() {
            return "";
        }

        public int getBindCount() {
            return 0;
        }
    }
}

