/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.FetchConfig;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.LinkedHashSet;

public class OrmQueryPropertiesParser {
    private static Response EMPTY = new Response();
    private String inputProperties;
    private String outputProperties = "";
    private boolean allProperties;
    private boolean readOnly;
    private boolean cache;
    private int queryFetchBatch = -1;
    private int lazyFetchBatch = -1;

    public static Response parse(String rawProperties) {
        return new OrmQueryPropertiesParser(rawProperties).parse();
    }

    private OrmQueryPropertiesParser(String inputProperties) {
        this.inputProperties = inputProperties;
    }

    private Response parse() {
        if (this.inputProperties == null || this.inputProperties.isEmpty()) {
            return EMPTY;
        }
        int pos = this.inputProperties.indexOf("+readonly");
        if (pos > -1) {
            this.inputProperties = StringHelper.replaceString(this.inputProperties, "+readonly", "");
            this.readOnly = true;
        }
        if ((pos = this.inputProperties.indexOf("+cache")) > -1) {
            this.inputProperties = StringHelper.replaceString(this.inputProperties, "+cache", "");
            this.cache = true;
        }
        if ((pos = this.inputProperties.indexOf("+query")) > -1) {
            this.queryFetchBatch = this.parseBatchHint(pos, "+query");
        }
        if ((pos = this.inputProperties.indexOf("+lazy")) > -1) {
            this.lazyFetchBatch = this.parseBatchHint(pos, "+lazy");
        }
        LinkedHashSet<String> included = this.parseIncluded();
        String properties = this.allProperties ? "*" : this.outputProperties;
        return new Response(this.readOnly, this.cache, this.queryFetchBatch, this.lazyFetchBatch, properties, included);
    }

    private LinkedHashSet<String> parseIncluded() {
        this.inputProperties = this.inputProperties.trim();
        if (this.inputProperties.isEmpty()) {
            return null;
        }
        if (this.inputProperties.equals("*")) {
            this.allProperties = true;
            return null;
        }
        String[] res = this.inputProperties.split(",");
        StringBuilder sb = new StringBuilder(70);
        LinkedHashSet<String> propertySet = new LinkedHashSet<String>(res.length * 2);
        int count = 0;
        for (int i = 0; i < res.length; ++i) {
            String temp = res[i].trim();
            if (temp.isEmpty()) continue;
            if (count > 0) {
                sb.append(",");
            }
            sb.append(temp);
            propertySet.add(temp);
            ++count;
        }
        if (propertySet.isEmpty()) {
            return null;
        }
        if (propertySet.contains("*")) {
            this.allProperties = true;
            return null;
        }
        this.outputProperties = sb.toString();
        return propertySet;
    }

    private int parseBatchHint(int pos, String option) {
        int startPos = pos + option.length();
        int endPos = this.findEndPos(startPos, this.inputProperties);
        if (endPos == -1) {
            this.inputProperties = StringHelper.replaceString(this.inputProperties, option, "");
            return 0;
        }
        String batchParam = this.inputProperties.substring(startPos + 1, endPos);
        this.inputProperties = endPos + 1 >= this.inputProperties.length() ? this.inputProperties.substring(0, pos) : this.inputProperties.substring(0, pos) + this.inputProperties.substring(endPos + 1);
        return Integer.parseInt(batchParam);
    }

    private int findEndPos(int pos, String props) {
        if (pos < props.length() && props.charAt(pos) == '(') {
            int endPara = props.indexOf(41, pos + 1);
            if (endPara == -1) {
                throw new RuntimeException("Error could not find ')' in " + props + " after position " + pos);
            }
            return endPara;
        }
        return -1;
    }

    public static class Response {
        final boolean readOnly;
        final boolean cache;
        final FetchConfig fetchConfig;
        final String properties;
        final LinkedHashSet<String> included;

        public Response(boolean readOnly, boolean cache, int queryFetchBatch, int lazyFetchBatch, String properties, LinkedHashSet<String> included) {
            this.readOnly = readOnly;
            this.cache = cache;
            this.properties = properties;
            this.included = included;
            this.fetchConfig = lazyFetchBatch > -1 || queryFetchBatch > -1 ? new FetchConfig().lazy(lazyFetchBatch).query(queryFetchBatch) : OrmQueryProperties.DEFAULT_FETCH;
        }

        public Response() {
            this.readOnly = false;
            this.cache = false;
            this.fetchConfig = OrmQueryProperties.DEFAULT_FETCH;
            this.properties = "";
            this.included = null;
        }
    }
}

