/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.FetchPath;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.event.readaudit.ReadEvent;
import com.avaje.ebean.plugin.BeanType;
import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.CQueryPlanKey;
import com.avaje.ebeaninternal.api.HashQuery;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.api.SpiNamedParam;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiQuerySecondary;
import com.avaje.ebeaninternal.server.autotune.ProfilingListener;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionList;
import com.avaje.ebeaninternal.server.expression.SimpleExpression;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import com.avaje.ebeaninternal.server.querydefn.ONamedParam;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryPlanKey;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.server.querydefn.OrmQuerySecondary;
import com.avaje.ebeaninternal.server.querydefn.OrmUpdateProperties;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultOrmQuery<T>
implements SpiQuery<T> {
    public static final String DEFAULT_QUERY_NAME = "default";
    private static final FetchConfig FETCH_QUERY = new FetchConfig().query();
    private static final FetchConfig FETCH_LAZY = new FetchConfig().lazy();
    private final Class<T> beanType;
    private final BeanDescriptor<T> beanDescriptor;
    private final EbeanServer server;
    private final ExpressionFactory expressionFactory;
    private TableJoin m2mIncludeJoin;
    private ProfilingListener profilingListener;
    private boolean cancelled;
    private CancelableQuery cancelableQuery;
    private SpiQuery.Type type;
    private SpiQuery.Mode mode = SpiQuery.Mode.NORMAL;
    private OrmQueryDetail detail;
    private int maxRows;
    private int firstRow;
    private boolean disableLazyLoading;
    private int lazyLoadBatchSize;
    private OrderBy<T> orderBy;
    private String loadMode;
    private String loadDescription;
    private String generatedSql;
    private String lazyLoadProperty;
    private String lazyLoadManyPath;
    private boolean distinct;
    private boolean sqlDistinct;
    private boolean futureFetch;
    private ReadEvent futureFetchAudit;
    private List<Object> partialIds;
    private int timeout;
    private String mapKey;
    private Object id;
    private Map<String, ONamedParam> namedParams;
    private BindParams bindParams;
    private DefaultExpressionList<T> textExpressions;
    private DefaultExpressionList<T> whereExpressions;
    private DefaultExpressionList<T> havingExpressions;
    private boolean asOfBaseTable;
    private int asOfTableCount;
    private Timestamp asOf;
    private SpiQuery.TemporalMode temporalMode = SpiQuery.TemporalMode.CURRENT;
    private Timestamp versionsStart;
    private Timestamp versionsEnd;
    private List<String> softDeletePredicates;
    private boolean disableReadAudit;
    private int bufferFetchSizeHint;
    private boolean usageProfiling = true;
    private boolean loadBeanCache;
    private boolean excludeBeanCache;
    private Boolean useQueryCache;
    private Boolean readOnly;
    private PersistenceContextScope persistenceContextScope;
    private Boolean autoTune;
    private boolean forUpdate;
    private boolean autoTuned;
    private boolean logSecondaryQuery;
    private String rootTableAlias;
    private ObjectGraphNode parentNode;
    private BeanPropertyAssocMany<?> lazyLoadForParentsProperty;
    private CQueryPlanKey queryPlanKey;
    private PersistenceContext persistenceContext;
    private ManyWhereJoins manyWhereJoins;
    private RawSql rawSql;
    private boolean useDocStore;
    private OrmUpdateProperties updateProperties;
    private List<SpiQuery<?>> loggedSecondaryQueries;

    public DefaultOrmQuery(BeanDescriptor<T> desc, EbeanServer server, ExpressionFactory expressionFactory) {
        this.beanDescriptor = desc;
        this.beanType = desc.getBeanType();
        this.server = server;
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
    }

    @Override
    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public void checkIdEqualTo() {
        if (this.id == null && this.whereExpressions != null) {
            this.id = this.whereExpressions.idEqualTo(this.beanDescriptor.getIdName());
            if (this.id != null) {
                this.whereExpressions = null;
            }
        }
    }

    @Override
    public boolean isAutoTunable() {
        return this.beanDescriptor.isAutoTunable();
    }

    @Override
    public Query<T> setUseDocStore(boolean useDocStore) {
        this.useDocStore = useDocStore;
        return this;
    }

    @Override
    public boolean isUseDocStore() {
        return this.useDocStore;
    }

    @Override
    public Query<T> apply(FetchPath fetchPath) {
        fetchPath.apply(this);
        return this;
    }

    @Override
    public void addSoftDeletePredicate(String softDeletePredicate) {
        if (this.softDeletePredicates == null) {
            this.softDeletePredicates = new ArrayList<String>();
        }
        this.softDeletePredicates.add(softDeletePredicate);
    }

    @Override
    public List<String> getSoftDeletePredicates() {
        return this.softDeletePredicates;
    }

    @Override
    public boolean isAsOfBaseTable() {
        return this.asOfBaseTable;
    }

    @Override
    public void setAsOfBaseTable() {
        this.asOfBaseTable = true;
    }

    @Override
    public void incrementAsOfTableCount() {
        ++this.asOfTableCount;
    }

    @Override
    public int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    @Override
    public Timestamp getAsOf() {
        return this.asOf;
    }

    @Override
    public DefaultOrmQuery<T> asOf(Timestamp asOfDateTime) {
        this.temporalMode = asOfDateTime != null ? SpiQuery.TemporalMode.AS_OF : SpiQuery.TemporalMode.CURRENT;
        this.asOf = asOfDateTime;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> asDraft() {
        this.temporalMode = SpiQuery.TemporalMode.DRAFT;
        return this;
    }

    @Override
    public Query<T> setIncludeSoftDeletes() {
        this.temporalMode = SpiQuery.TemporalMode.SOFT_DELETED;
        return this;
    }

    @Override
    public RawSql getRawSql() {
        return this.rawSql;
    }

    @Override
    public DefaultOrmQuery<T> setRawSql(RawSql rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public Query<T> setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
        return this;
    }

    @Override
    public String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    @Override
    public void setLazyLoadProperty(String lazyLoadProperty) {
        this.lazyLoadProperty = lazyLoadProperty;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    private void createExtraJoinsToSupportManyWhereClause() {
        this.manyWhereJoins = new ManyWhereJoins();
        if (this.whereExpressions != null) {
            this.whereExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        if (!this.manyWhereJoins.isEmpty()) {
            this.setSqlDistinct(true);
        }
    }

    @Override
    public ManyWhereJoins getManyWhereJoins() {
        return this.manyWhereJoins;
    }

    @Override
    public boolean selectAllForLazyLoadProperty() {
        if (this.lazyLoadProperty != null && !this.detail.containsProperty(this.lazyLoadProperty)) {
            this.detail.select("*");
            return true;
        }
        return false;
    }

    protected List<OrmQueryProperties> removeQueryJoins() {
        List<OrmQueryProperties> queryJoins = this.detail.removeSecondaryQueries();
        if (queryJoins != null && this.orderBy != null) {
            for (int i = 0; i < queryJoins.size(); ++i) {
                OrmQueryProperties joinPath = queryJoins.get(i);
                List<OrderBy.Property> properties = this.orderBy.getProperties();
                Iterator<OrderBy.Property> it = properties.iterator();
                while (it.hasNext()) {
                    OrderBy.Property property = it.next();
                    if (!property.getProperty().startsWith(joinPath.getPath())) continue;
                    it.remove();
                    joinPath.addSecJoinOrderProperty(property);
                }
            }
        }
        return queryJoins;
    }

    protected List<OrmQueryProperties> removeLazyJoins() {
        return this.detail.removeSecondaryLazyQueries();
    }

    @Override
    public void setLazyLoadManyPath(String lazyLoadManyPath) {
        this.lazyLoadManyPath = lazyLoadManyPath;
    }

    @Override
    public SpiQuerySecondary convertJoins() {
        if (!this.useDocStore) {
            this.createExtraJoinsToSupportManyWhereClause();
        }
        this.markQueryJoins();
        return new OrmQuerySecondary(this.removeQueryJoins(), this.removeLazyJoins());
    }

    private void markQueryJoins() {
        this.detail.markQueryJoins(this.beanDescriptor, this.lazyLoadManyPath, this.isAllowOneManyFetch());
    }

    private boolean isAllowOneManyFetch() {
        if (SpiQuery.Mode.LAZYLOAD_MANY.equals((Object)this.getMode())) {
            return false;
        }
        return !this.hasMaxRowsOrFirstRow() || this.isRawSql();
    }

    protected void setOrmQueryDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public void setDefaultSelectClause() {
        this.detail.setDefaultSelectClause(this.beanDescriptor);
    }

    @Override
    public void setDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        return this.detail.tuneFetchProperties(tunedDetail);
    }

    @Override
    public OrmQueryDetail getDetail() {
        return this.detail;
    }

    @Override
    public ExpressionList<T> filterMany(String prop) {
        OrmQueryProperties chunk = this.detail.getChunk(prop, true);
        return chunk.filterMany(this);
    }

    @Override
    public void setFilterMany(String prop, ExpressionList<?> filterMany) {
        if (filterMany != null) {
            OrmQueryProperties chunk = this.detail.getChunk(prop, true);
            chunk.setFilterMany((SpiExpressionList)filterMany);
        }
    }

    @Override
    public void prepareDocNested() {
        if (this.textExpressions != null) {
            this.textExpressions.prepareDocNested(this.beanDescriptor);
        }
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareDocNested(this.beanDescriptor);
        }
    }

    @Override
    public void setDelete() {
        this.maxRows = 0;
        this.firstRow = 0;
        this.forUpdate = false;
        this.rootTableAlias = "${RTA}";
        this.setSelectId();
    }

    @Override
    public void setSelectId() {
        this.detail.clear();
        this.select(this.beanDescriptor.getIdBinder().getIdProperty());
    }

    @Override
    public NaturalKeyBindParam getNaturalKeyBindParam() {
        NaturalKeyBindParam namedBind = null;
        if (this.bindParams != null && (namedBind = this.bindParams.getNaturalKeyBindParam()) == null) {
            return null;
        }
        if (this.whereExpressions != null) {
            SimpleExpression e;
            List<SpiExpression> exprList = this.whereExpressions.internalList();
            if (exprList.size() > 1) {
                return null;
            }
            if (exprList.isEmpty()) {
                return namedBind;
            }
            if (namedBind != null) {
                return null;
            }
            SpiExpression se = exprList.get(0);
            if (se instanceof SimpleExpression && (e = (SimpleExpression)se).isOpEquals()) {
                return new NaturalKeyBindParam(e.getPropName(), e.getValue());
            }
        }
        return null;
    }

    @Override
    public DefaultOrmQuery<T> copy() {
        return this.copy(this.server);
    }

    @Override
    public DefaultOrmQuery<T> copy(EbeanServer server) {
        DefaultOrmQuery<T> copy = new DefaultOrmQuery<T>(this.beanDescriptor, server, this.expressionFactory);
        copy.m2mIncludeJoin = this.m2mIncludeJoin;
        copy.profilingListener = this.profilingListener;
        copy.rootTableAlias = this.rootTableAlias;
        copy.distinct = this.distinct;
        copy.sqlDistinct = this.sqlDistinct;
        copy.timeout = this.timeout;
        copy.mapKey = this.mapKey;
        copy.id = this.id;
        copy.loadBeanCache = this.loadBeanCache;
        copy.excludeBeanCache = this.excludeBeanCache;
        copy.useQueryCache = this.useQueryCache;
        copy.readOnly = this.readOnly;
        if (this.detail != null) {
            copy.detail = this.detail.copy();
        }
        copy.temporalMode = this.temporalMode;
        copy.firstRow = this.firstRow;
        copy.maxRows = this.maxRows;
        if (this.orderBy != null) {
            copy.orderBy = this.orderBy.copy();
        }
        if (this.bindParams != null) {
            copy.bindParams = this.bindParams.copy();
        }
        if (this.whereExpressions != null) {
            copy.whereExpressions = this.whereExpressions.copy(copy);
        }
        if (this.havingExpressions != null) {
            copy.havingExpressions = this.havingExpressions.copy(copy);
        }
        copy.persistenceContextScope = this.persistenceContextScope;
        copy.usageProfiling = this.usageProfiling;
        copy.autoTune = this.autoTune;
        copy.parentNode = this.parentNode;
        copy.forUpdate = this.forUpdate;
        copy.rawSql = this.rawSql;
        return copy;
    }

    @Override
    public Query<T> setPersistenceContextScope(PersistenceContextScope scope) {
        this.persistenceContextScope = scope;
        return this;
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope;
    }

    @Override
    public SpiQuery.Type getType() {
        return this.type;
    }

    @Override
    public void setType(SpiQuery.Type type) {
        this.type = type;
    }

    @Override
    public String getLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public String getLoadMode() {
        return this.loadMode;
    }

    @Override
    public void setLoadDescription(String loadMode, String loadDescription) {
        this.loadMode = loadMode;
        this.loadDescription = loadDescription;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public void setLazyLoadForParents(BeanPropertyAssocMany<?> many) {
        this.lazyLoadForParentsProperty = many;
    }

    @Override
    public BeanPropertyAssocMany<?> getLazyLoadMany() {
        return this.lazyLoadForParentsProperty;
    }

    @Override
    public boolean isDetailEmpty() {
        return this.detail.isEmpty();
    }

    @Override
    public boolean isAutoTuned() {
        return this.autoTuned;
    }

    @Override
    public void setAutoTuned(boolean autoTuned) {
        this.autoTuned = autoTuned;
    }

    @Override
    public Boolean isAutoTune() {
        return this.autoTune;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }

    @Override
    public void setDefaultRawSqlIfRequired() {
        if (this.beanDescriptor.isRawSqlBased() && this.rawSql == null) {
            this.rawSql = this.beanDescriptor.getNamedRawSql(DEFAULT_QUERY_NAME);
        }
    }

    @Override
    public DefaultOrmQuery<T> setAutoTune(boolean autoTune) {
        this.autoTune = autoTune;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    @Override
    public ProfilingListener getProfilingListener() {
        return this.profilingListener;
    }

    @Override
    public void setProfilingListener(ProfilingListener profilingListener) {
        this.profilingListener = profilingListener;
    }

    @Override
    public SpiQuery.Mode getMode() {
        return this.mode;
    }

    @Override
    public SpiQuery.TemporalMode getTemporalMode() {
        return this.temporalMode;
    }

    @Override
    public boolean isAsOfQuery() {
        return this.asOf != null;
    }

    @Override
    public boolean isAsDraft() {
        return SpiQuery.TemporalMode.DRAFT == this.temporalMode;
    }

    @Override
    public boolean isIncludeSoftDeletes() {
        return SpiQuery.TemporalMode.SOFT_DELETED == this.temporalMode;
    }

    @Override
    public void setMode(SpiQuery.Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isUsageProfiling() {
        return this.usageProfiling;
    }

    @Override
    public void setUsageProfiling(boolean usageProfiling) {
        this.usageProfiling = usageProfiling;
    }

    @Override
    public void setLogSecondaryQuery(boolean logSecondaryQuery) {
        this.logSecondaryQuery = logSecondaryQuery;
    }

    @Override
    public boolean isLogSecondaryQuery() {
        return this.logSecondaryQuery;
    }

    @Override
    public List<SpiQuery<?>> getLoggedSecondaryQueries() {
        return this.loggedSecondaryQueries;
    }

    @Override
    public void logSecondaryQuery(SpiQuery<?> query) {
        if (this.loggedSecondaryQueries == null) {
            this.loggedSecondaryQueries = new ArrayList();
        }
        this.loggedSecondaryQueries.add(query);
    }

    @Override
    public void setParentNode(ObjectGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public ObjectGraphNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public ObjectGraphNode setOrigin(CallStack callStack) {
        ObjectGraphOrigin o = new ObjectGraphOrigin(this.calculateOriginQueryHash(), callStack, this.beanType.getName());
        this.parentNode = new ObjectGraphNode(o, null);
        return this.parentNode;
    }

    private int calculateOriginQueryHash() {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 31 + (this.type == null ? 0 : this.type.ordinal());
        return hc;
    }

    CQueryPlanKey createQueryPlanKey() {
        this.queryPlanKey = new OrmQueryPlanKey(this.m2mIncludeJoin, this.type, this.detail, this.maxRows, this.firstRow, this.disableLazyLoading, this.orderBy, this.distinct, this.sqlDistinct, this.mapKey, this.id, this.bindParams, this.whereExpressions, this.havingExpressions, this.temporalMode, this.forUpdate, this.rootTableAlias, this.rawSql, this.updateProperties);
        return this.queryPlanKey;
    }

    @Override
    public CQueryPlanKey prepare(BeanQueryRequest<?> request) {
        this.prepareExpressions(request);
        this.queryPlanKey = this.createQueryPlanKey();
        return this.queryPlanKey;
    }

    private void prepareExpressions(BeanQueryRequest<?> request) {
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareExpression(request);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.prepareExpression(request);
        }
    }

    @Override
    public int queryBindHash() {
        int hc = this.id == null ? 0 : this.id.hashCode();
        hc = hc * 31 + (this.whereExpressions == null ? 0 : this.whereExpressions.queryBindHash());
        hc = hc * 31 + (this.havingExpressions == null ? 0 : this.havingExpressions.queryBindHash());
        hc = hc * 31 + (this.bindParams == null ? 0 : this.bindParams.queryBindHash());
        hc = hc * 31 + (this.asOf == null ? 0 : this.asOf.hashCode());
        hc = hc * 31 + (this.versionsStart == null ? 0 : this.versionsStart.hashCode());
        hc = hc * 31 + (this.versionsEnd == null ? 0 : this.versionsEnd.hashCode());
        return hc;
    }

    @Override
    public HashQuery queryHash() {
        int hc = this.queryBindHash();
        return new HashQuery(this.queryPlanKey, hc);
    }

    @Override
    public boolean isRawSql() {
        return this.rawSql != null;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean hasMaxRowsOrFirstRow() {
        return this.maxRows > 0 || this.firstRow > 0;
    }

    @Override
    public boolean isVersionsBetween() {
        return this.versionsStart != null;
    }

    @Override
    public Timestamp getVersionStart() {
        return this.versionsStart;
    }

    @Override
    public Timestamp getVersionEnd() {
        return this.versionsEnd;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public DefaultOrmQuery<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public boolean isExcludeBeanCache() {
        return this.excludeBeanCache || this.isAsDraft();
    }

    @Override
    public boolean isUseBeanCache() {
        return !this.isExcludeBeanCache() && this.beanDescriptor.isBeanCaching();
    }

    @Override
    public boolean isUseQueryCache() {
        return !this.isAsDraft() && Boolean.TRUE.equals(this.useQueryCache);
    }

    @Override
    public DefaultOrmQuery<T> setUseCache(boolean useCache) {
        this.excludeBeanCache = !useCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setUseQueryCache(boolean useQueryCache) {
        this.useQueryCache = useQueryCache;
        return this;
    }

    @Override
    public boolean isLoadBeanCache() {
        return !this.isAsDraft() && this.loadBeanCache;
    }

    @Override
    public DefaultOrmQuery<T> setLoadBeanCache(boolean loadBeanCache) {
        this.loadBeanCache = loadBeanCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> select(String columns) {
        this.detail.select(columns);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property) {
        return this.fetch(property, null, null);
    }

    @Override
    public Query<T> fetchQuery(String property) {
        return this.fetch(property, null, FETCH_QUERY);
    }

    @Override
    public Query<T> fetchLazy(String property) {
        return this.fetch(property, null, FETCH_LAZY);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, FetchConfig joinConfig) {
        return this.fetch(property, null, joinConfig);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns) {
        return this.fetch(property, columns, null);
    }

    @Override
    public Query<T> fetchQuery(String property, String columns) {
        return this.fetch(property, columns, FETCH_QUERY);
    }

    @Override
    public Query<T> fetchLazy(String property, String columns) {
        return this.fetch(property, columns, FETCH_LAZY);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns, FetchConfig config) {
        this.detail.fetch(property, columns, config);
        return this;
    }

    @Override
    public int delete() {
        return this.server.delete(this, null);
    }

    @Override
    public int update() {
        return this.server.update(this, null);
    }

    @Override
    public List<Object> findIds() {
        return this.server.findIds(this, null);
    }

    @Override
    public int findCount() {
        return this.server.findCount(this, null);
    }

    @Override
    public int findRowCount() {
        return this.findCount();
    }

    @Override
    public void findEachWhile(QueryEachWhileConsumer<T> consumer) {
        this.server.findEachWhile(this, consumer, null);
    }

    @Override
    public void findEach(QueryEachConsumer<T> consumer) {
        this.server.findEach(this, consumer, null);
    }

    @Override
    public List<Version<T>> findVersions() {
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        return this.server.findVersions(this, null);
    }

    @Override
    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("start and end must not be null");
        }
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        this.versionsStart = start;
        this.versionsEnd = end;
        return this.server.findVersions(this, null);
    }

    @Override
    public List<T> findList() {
        return this.server.findList(this, null);
    }

    @Override
    public Set<T> findSet() {
        return this.server.findSet(this, null);
    }

    @Override
    public Map<?, T> findMap() {
        return this.server.findMap(this, null);
    }

    @Override
    public <K> Map<K, T> findMap(String keyProperty, Class<K> keyType) {
        this.setMapKey(keyProperty);
        return this.findMap();
    }

    @Override
    public T findUnique() {
        return this.server.findUnique(this, null);
    }

    @Override
    public FutureIds<T> findFutureIds() {
        return this.server.findFutureIds(this, null);
    }

    @Override
    public FutureList<T> findFutureList() {
        return this.server.findFutureList(this, null);
    }

    @Override
    public FutureRowCount<T> findFutureCount() {
        return this.server.findFutureCount(this, null);
    }

    @Override
    public FutureRowCount<T> findFutureRowCount() {
        return this.findFutureCount();
    }

    @Override
    public PagedList<T> findPagedList() {
        return this.server.findPagedList(this, null);
    }

    @Override
    public DefaultOrmQuery<T> setParameter(int position, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(position, value);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setParameter(String name, Object value) {
        ONamedParam param;
        if (this.namedParams != null && (param = this.namedParams.get(name)) != null) {
            param.setValue(value);
            return this;
        }
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(name, value);
        return this;
    }

    @Override
    public OrderBy<T> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OrderBy<T> orderBy() {
        return this.order();
    }

    @Override
    public OrderBy<T> order() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy(this, null);
        }
        return this.orderBy;
    }

    @Override
    public DefaultOrmQuery<T> orderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    @Override
    public DefaultOrmQuery<T> order(String orderByClause) {
        this.orderBy = orderByClause == null || orderByClause.trim().isEmpty() ? null : new OrderBy(this, orderByClause);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setOrderBy(OrderBy<T> orderBy) {
        return this.setOrder((OrderBy)orderBy);
    }

    @Override
    public DefaultOrmQuery<T> setOrder(OrderBy<T> orderBy) {
        this.orderBy = orderBy;
        if (orderBy != null) {
            orderBy.setQuery(this);
        }
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public DefaultOrmQuery<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public boolean isDistinctQuery() {
        return this.distinct || this.sqlDistinct;
    }

    @Override
    public void setSqlDistinct(boolean sqlDistinct) {
        this.sqlDistinct = sqlDistinct;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    public String toString() {
        return "Query [" + this.whereExpressions + "]";
    }

    @Override
    public TableJoin getM2mIncludeJoin() {
        return this.m2mIncludeJoin;
    }

    @Override
    public void setM2MIncludeJoin(TableJoin m2mIncludeJoin) {
        this.m2mIncludeJoin = m2mIncludeJoin;
    }

    @Override
    public Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        this.disableLazyLoading = disableLazyLoading;
        return this;
    }

    @Override
    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public int getFirstRow() {
        return this.firstRow;
    }

    @Override
    public DefaultOrmQuery<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public DefaultOrmQuery<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public DefaultOrmQuery<T> setMapKey(String mapKey) {
        this.mapKey = mapKey;
        return this;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public DefaultOrmQuery<T> setId(Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }

    @Override
    public DefaultOrmQuery<T> where(Expression expression) {
        this.where().add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> text() {
        if (this.textExpressions == null) {
            this.useDocStore = true;
            this.textExpressions = new DefaultExpressionList(this);
        }
        return this.textExpressions;
    }

    @Override
    public ExpressionList<T> where() {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this, null);
        }
        return this.whereExpressions;
    }

    @Override
    public void simplifyExpressions() {
        if (this.whereExpressions != null) {
            this.whereExpressions.simplify();
        }
    }

    @Override
    public DefaultOrmQuery<T> having(Expression expression) {
        this.having().add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> having() {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this, null);
        }
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getHavingExpressions() {
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getWhereExpressions() {
        return this.whereExpressions;
    }

    @Override
    public SpiExpressionList<T> getTextExpression() {
        return this.textExpressions;
    }

    @Override
    public String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
    }

    @Override
    public void checkNamedParameters() {
        if (this.namedParams != null) {
            Collection<ONamedParam> values = this.namedParams.values();
            for (ONamedParam value : values) {
                value.checkValueSet();
            }
        }
    }

    @Override
    public SpiNamedParam createNamedParameter(String name) {
        ONamedParam param;
        if (this.namedParams == null) {
            this.namedParams = new HashMap<String, ONamedParam>();
        }
        if ((param = this.namedParams.get(name)) == null) {
            param = new ONamedParam(name);
            this.namedParams.put(name, param);
        }
        return param;
    }

    @Override
    public void setDefaultFetchBuffer(int fetchSize) {
        if (this.bufferFetchSizeHint == 0) {
            this.bufferFetchSizeHint = fetchSize;
        }
    }

    @Override
    public Query<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    @Override
    public Query<T> setDisableReadAuditing() {
        this.disableReadAudit = true;
        return this;
    }

    @Override
    public boolean isDisableReadAudit() {
        return this.disableReadAudit;
    }

    @Override
    public List<Object> getIdList() {
        return this.partialIds;
    }

    @Override
    public void setIdList(List<Object> partialIds) {
        this.partialIds = partialIds;
    }

    @Override
    public boolean isFutureFetch() {
        return this.futureFetch;
    }

    @Override
    public void setFutureFetch(boolean backgroundFetch) {
        this.futureFetch = backgroundFetch;
    }

    @Override
    public void setFutureFetchAudit(ReadEvent event) {
        this.futureFetchAudit = event;
    }

    @Override
    public ReadEvent getFutureFetchAudit() {
        return this.futureFetchAudit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelableQuery = cancelableQuery;
        }
    }

    @Override
    public Query<T> alias(String alias) {
        this.rootTableAlias = alias;
        return this;
    }

    @Override
    public String getAlias() {
        return this.rootTableAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelled = true;
            if (this.cancelableQuery != null) {
                this.cancelableQuery.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            return this.cancelled;
        }
    }

    @Override
    public Set<String> validate() {
        return this.server.validateQuery(this);
    }

    @Override
    public Set<String> validate(BeanType<T> desc) {
        SpiExpressionValidation validation = new SpiExpressionValidation(desc);
        if (this.whereExpressions != null) {
            this.whereExpressions.validate(validation);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.validate(validation);
        }
        if (this.orderBy != null) {
            for (OrderBy.Property property : this.orderBy.getProperties()) {
                validation.validate(property.getProperty());
            }
        }
        return validation.getUnknownProperties();
    }

    public void setUpdateProperties(OrmUpdateProperties updateProperties) {
        this.updateProperties = updateProperties;
    }

    @Override
    public OrmUpdateProperties getUpdateProperties() {
        return this.updateProperties;
    }
}

