/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlBeanLoad;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import com.avaje.ebeaninternal.server.query.SqlTreeProperties;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlTreeNodeBean
implements SqlTreeNode {
    private static final SqlTreeNode[] NO_CHILDREN = new SqlTreeNode[0];
    protected final BeanDescriptor<?> desc;
    protected final IdBinder idBinder;
    protected final SqlTreeNode[] children;
    protected final boolean partialObject;
    protected final BeanProperty[] properties;
    protected final String extraWhere;
    protected final BeanPropertyAssoc<?> nodeBeanProp;
    protected final boolean readId;
    protected final boolean disableLazyLoad;
    protected final InheritInfo inheritInfo;
    protected final String prefix;
    protected final Map<String, String> pathMap;
    protected final BeanPropertyAssocMany<?> lazyLoadParent;
    protected final SpiQuery.TemporalMode temporalMode;
    protected final boolean temporalVersions;
    private final IdBinder lazyLoadParentIdBinder;
    protected String baseTableAlias;
    private boolean intersectionAsOfTableAlias;

    public SqlTreeNodeBean(BeanDescriptor<?> desc, SqlTreeProperties props, boolean withId, boolean disableLazyLoad) {
        this(null, null, desc, props, null, withId, null, null, disableLazyLoad);
    }

    public SqlTreeNodeBean(String prefix, BeanPropertyAssoc<?> beanProp, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean disableLazyLoad) {
        this(prefix, beanProp, beanProp.getTargetDescriptor(), props, myChildren, true, null, SpiQuery.TemporalMode.CURRENT, disableLazyLoad);
    }

    public SqlTreeNodeBean(BeanDescriptor<?> desc, SqlTreeProperties props, List<SqlTreeNode> myList, boolean withId, BeanPropertyAssocMany<?> many, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this(null, null, desc, props, myList, withId, many, temporalMode, disableLazyLoad);
    }

    private SqlTreeNodeBean(String prefix, BeanPropertyAssoc<?> beanProp, BeanDescriptor<?> desc, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean withId, BeanPropertyAssocMany<?> lazyLoadParent, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this.lazyLoadParent = lazyLoadParent;
        this.lazyLoadParentIdBinder = lazyLoadParent == null ? null : lazyLoadParent.getBeanDescriptor().getIdBinder();
        this.prefix = prefix;
        this.desc = desc;
        this.inheritInfo = desc.getInheritInfo();
        this.idBinder = desc.getIdBinder();
        this.temporalMode = temporalMode;
        this.temporalVersions = temporalMode == SpiQuery.TemporalMode.VERSIONS;
        this.nodeBeanProp = beanProp;
        this.extraWhere = beanProp == null ? null : beanProp.getExtraWhere();
        this.readId = withId && desc.getIdProperty() != null;
        this.disableLazyLoad = disableLazyLoad || !this.readId || desc.isRawSqlBased() || this.temporalVersions;
        this.partialObject = props.isPartialObject();
        this.properties = props.getProps();
        this.children = myChildren == null ? NO_CHILDREN : myChildren.toArray(new SqlTreeNode[myChildren.size()]);
        this.pathMap = this.createPathMap(prefix, desc);
    }

    private Map<String, String> createPathMap(String prefix, BeanDescriptor<?> desc) {
        BeanPropertyAssocMany<?>[] manys = desc.propertiesMany();
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < manys.length; ++i) {
            String name = manys[i].getName();
            m.put(name, this.getPath(prefix, name));
        }
        return m;
    }

    private String getPath(String prefix, String propertyName) {
        if (prefix == null) {
            return propertyName;
        }
        return prefix + "." + propertyName;
    }

    @Override
    public void buildRawSqlSelectChain(List<String> selectChain) {
        int i;
        if (this.readId) {
            if (this.desc.hasInheritance()) {
                selectChain.add(this.getPath(this.prefix, this.desc.getInheritInfo().getDiscriminatorColumn()));
            }
            this.idBinder.buildRawSqlSelectChain(this.prefix, selectChain);
        }
        int x = this.properties.length;
        for (i = 0; i < x; ++i) {
            this.properties[i].buildRawSqlSelectChain(this.prefix, selectChain);
        }
        for (i = 0; i < this.children.length; ++i) {
            this.children[i].buildRawSqlSelectChain(selectChain);
        }
    }

    @Override
    public <T> Version<T> loadVersion(DbReadContext ctx) throws SQLException {
        Timestamp start = ctx.getDataReader().getTimestamp();
        Timestamp end = ctx.getDataReader().getTimestamp();
        EntityBean bean = this.load(ctx, null, null);
        return new Version<EntityBean>(bean, start, end);
    }

    @Override
    public EntityBean load(DbReadContext ctx, EntityBean parentBean, EntityBean contextParent) throws SQLException {
        int i;
        int x;
        PersistenceContext persistenceContext;
        BeanDescriptor<?> localDesc;
        Class<?> localType;
        EntityBean localBean;
        IdBinder localIdBinder;
        Object lazyLoadParentId = null;
        if (this.lazyLoadParentIdBinder != null) {
            lazyLoadParentId = this.lazyLoadParentIdBinder.read(ctx);
        }
        EntityBean contextBean = null;
        if (this.inheritInfo != null) {
            InheritInfo localInfo = this.inheritInfo.readType(ctx);
            if (localInfo == null) {
                localIdBinder = this.idBinder;
                localBean = null;
                localType = null;
                localDesc = this.desc;
            } else {
                localBean = localInfo.createEntityBean();
                localType = localInfo.getType();
                localIdBinder = localInfo.getIdBinder();
                localDesc = localInfo.desc();
            }
        } else {
            localType = null;
            localDesc = this.desc;
            localBean = this.desc.createEntityBean();
            localIdBinder = this.idBinder;
        }
        SpiQuery.Mode queryMode = ctx.getQueryMode();
        PersistenceContext persistenceContext2 = persistenceContext = !this.readId || this.temporalVersions ? null : ctx.getPersistenceContext();
        if (this.readId) {
            Object id = localIdBinder.readSet(ctx, localBean);
            if (id == null) {
                localBean = null;
            } else if (!this.temporalVersions) {
                contextBean = (EntityBean)localDesc.contextPutIfAbsent(persistenceContext, id, localBean);
                if (contextBean == null) {
                    contextBean = localBean;
                } else {
                    localBean = this.isLoadContextBeanNeeded(queryMode, contextBean) ? contextBean : null;
                }
            }
        }
        ctx.setCurrentPrefix(this.prefix, this.pathMap);
        ctx.propagateState(localBean);
        SqlBeanLoad sqlBeanLoad = new SqlBeanLoad(ctx, localType, localBean, queryMode);
        if (this.inheritInfo == null) {
            x = this.properties.length;
            for (i = 0; i < x; ++i) {
                this.properties[i].load(sqlBeanLoad);
            }
        } else {
            x = this.properties.length;
            for (i = 0; i < x; ++i) {
                BeanProperty p = localDesc.getBeanProperty(this.properties[i].getName());
                if (p != null) {
                    p.load(sqlBeanLoad);
                    continue;
                }
                this.properties[i].loadIgnore(ctx);
            }
        }
        boolean lazyLoadMany = false;
        if (localBean == null && queryMode.equals((Object)SpiQuery.Mode.LAZYLOAD_MANY)) {
            localBean = contextBean;
            lazyLoadMany = true;
        }
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            this.children[i2].load(ctx, localBean, contextBean);
        }
        if (!lazyLoadMany && localBean != null) {
            ctx.setCurrentPrefix(this.prefix, this.pathMap);
            if (this.readId && !this.temporalVersions) {
                this.createListProxies(localDesc, ctx, localBean, this.disableLazyLoad);
            }
            if (this.temporalMode == SpiQuery.TemporalMode.DRAFT) {
                localDesc.setDraft(localBean);
            }
            localDesc.postLoad(localBean);
            EntityBeanIntercept ebi = localBean._ebean_getIntercept();
            ebi.setPersistenceContext(persistenceContext);
            if (SpiQuery.Mode.LAZYLOAD_BEAN.equals((Object)queryMode)) {
                ebi.setLoadedLazy();
            } else if (this.readId) {
                ebi.setLoaded();
            }
            if (this.disableLazyLoad) {
                ebi.setDisableLazyLoad(true);
            } else if (this.partialObject) {
                if (this.readId) {
                    ctx.register(null, ebi);
                }
            } else {
                ebi.setFullyLoadedBean(true);
            }
            if (ctx.isAutoTuneProfiling() && !this.disableLazyLoad) {
                ctx.profileBean(ebi, this.prefix);
            }
        }
        if (parentBean != null) {
            this.nodeBeanProp.setValue(parentBean, contextBean);
        }
        if (!this.readId || this.temporalVersions) {
            return localBean;
        }
        if (lazyLoadParentId != null) {
            ctx.setLazyLoadedChildBean(contextBean, lazyLoadParentId);
        }
        return contextBean;
    }

    private void createListProxies(BeanDescriptor<?> localDesc, DbReadContext ctx, EntityBean localBean, boolean disableLazyLoad) {
        BeanPropertyAssocMany<?> fetchedMany = ctx.getManyProperty();
        BeanPropertyAssocMany<?>[] manys = localDesc.propertiesMany();
        for (int i = 0; i < manys.length; ++i) {
            BeanCollection<?> ref;
            if (fetchedMany != null && fetchedMany.equals(manys[i]) || (ref = manys[i].createReferenceIfNull(localBean)) == null) continue;
            if (disableLazyLoad) {
                ref.setDisableLazyLoad(true);
            }
            if (ref.isRegisteredWithLoadContext()) continue;
            ctx.register(manys[i].getName(), ref);
        }
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        if (this.temporalVersions) {
            ctx.appendHistorySysPeriod();
        }
        if (this.lazyLoadParent != null) {
            this.lazyLoadParent.addSelectExported(ctx, this.prefix);
        }
        if (!subQuery && this.inheritInfo != null) {
            ctx.appendColumn(this.inheritInfo.getDiscriminatorColumn());
        }
        if (this.readId) {
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
        }
        this.appendSelect(ctx, subQuery, this.properties);
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].appendSelect(ctx, subQuery);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    private void appendSelect(DbSqlContext ctx, boolean subQuery, BeanProperty[] props) {
        for (int i = 0; i < props.length; ++i) {
            props[i].appendSelect(ctx, subQuery);
        }
    }

    private void appendSelectId(DbSqlContext ctx, BeanProperty prop) {
        if (prop != null) {
            prop.appendSelect(ctx, false);
        }
    }

    @Override
    public void appendWhere(DbSqlContext ctx) {
        if (this.inheritInfo != null && this.nodeBeanProp == null && !this.inheritInfo.isRoot()) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            ctx.append(" ").append(ctx.getTableAlias(this.prefix)).append(".");
            ctx.append(this.inheritInfo.getWhere()).append(" ");
        }
        if (this.extraWhere != null) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            String ta = ctx.getTableAlias(this.prefix);
            String ew = StringHelper.replaceString(this.extraWhere, "${ta}", ta);
            ctx.append(" ").append(ew).append(" ");
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].appendWhere(ctx);
        }
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        int i;
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        this.baseTableAlias = ctx.getTableAlias(this.prefix);
        joinType = this.appendFromBaseTable(ctx, joinType);
        for (i = 0; i < this.properties.length; ++i) {
            this.properties[i].appendFrom(ctx, joinType);
        }
        for (i = 0; i < this.children.length; ++i) {
            this.children[i].appendFrom(ctx, joinType);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public void addSoftDeletePredicate(SpiQuery<?> query) {
        if (this.desc.isSoftDelete()) {
            query.addSoftDeletePredicate(this.desc.getSoftDeletePredicate(this.baseTableAlias));
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].addSoftDeletePredicate(query);
        }
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
        if (this.desc.isHistorySupport()) {
            query.incrementAsOfTableCount();
        }
        if (this.lazyLoadParent != null && this.lazyLoadParent.isManyToManyWithHistory()) {
            query.incrementAsOfTableCount();
        }
        if (this.intersectionAsOfTableAlias) {
            query.incrementAsOfTableCount();
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].addAsOfTableAlias(query);
        }
    }

    public SqlJoinType appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        BeanPropertyAssocMany manyProp;
        if (this.nodeBeanProp instanceof BeanPropertyAssocMany && (manyProp = (BeanPropertyAssocMany)this.nodeBeanProp).isManyToMany()) {
            String alias = ctx.getTableAlias(this.prefix);
            String[] split = SplitName.split(this.prefix);
            String parentAlias = ctx.getTableAlias(split[0]);
            String alias2 = alias + "z_";
            TableJoin manyToManyJoin = manyProp.getIntersectionTableJoin();
            manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
            if (!manyProp.isExcludedFromHistory()) {
                this.intersectionAsOfTableAlias = true;
            }
            return this.nodeBeanProp.addJoin(joinType, alias2, alias, ctx);
        }
        return this.nodeBeanProp.addJoin(joinType, this.prefix, ctx);
    }

    public String toString() {
        return "SqlTreeNodeBean: " + this.desc;
    }

    private boolean isLoadContextBeanNeeded(SpiQuery.Mode queryMode, EntityBean contextBean) {
        if (queryMode.isLoadContextBean()) {
            return true;
        }
        return !contextBean._ebean_getIntercept().isFullyLoadedBean();
    }

    @Override
    public boolean hasMany() {
        for (SqlTreeNode child : this.children) {
            if (!child.hasMany()) continue;
            return true;
        }
        return false;
    }
}

