/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.SqlRow;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.core.RelationalQueryRequest;
import com.avaje.ebeaninternal.server.persist.Binder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.PersistenceException;

public class DefaultRelationalQueryEngine
implements RelationalQueryEngine {
    private final Binder binder;
    private final String dbTrueValue;

    public DefaultRelationalQueryEngine(Binder binder, String dbTrueValue) {
        this.binder = binder;
        this.dbTrueValue = dbTrueValue == null ? "true" : dbTrueValue;
    }

    @Override
    public void findEach(RelationalQueryRequest request, QueryEachWhileConsumer<SqlRow> consumer) {
        long startTime = System.currentTimeMillis();
        try {
            request.executeSql(this.binder);
            while (request.next() && consumer.accept(this.readRow(request))) {
            }
            this.logSummary(request, startTime);
        }
        catch (Exception e) {
            throw new PersistenceException(Message.msg("fetch.error", e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public void findEach(RelationalQueryRequest request, QueryEachConsumer<SqlRow> consumer) {
        long startTime = System.currentTimeMillis();
        try {
            request.executeSql(this.binder);
            while (request.next()) {
                consumer.accept(this.readRow(request));
            }
            this.logSummary(request, startTime);
        }
        catch (Exception e) {
            throw new PersistenceException(Message.msg("fetch.error", e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    @Override
    public List<SqlRow> findList(RelationalQueryRequest request) {
        long startTime = System.currentTimeMillis();
        try {
            request.executeSql(this.binder);
            ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
            while (request.next()) {
                rows.add(this.readRow(request));
            }
            this.logSummary(request, startTime);
            ArrayList<SqlRow> arrayList = rows;
            return arrayList;
        }
        catch (Exception e) {
            throw new PersistenceException(Message.msg("fetch.error", e.getMessage(), request.getSql()), (Throwable)e);
        }
        finally {
            request.close();
        }
    }

    private void logSummary(RelationalQueryRequest request, long startTime) {
        if (request.isLogSummary()) {
            long exeTime = System.currentTimeMillis() - startTime;
            request.getTransaction().logSummary("SqlQuery  rows[" + request.getRowCount() + "] time[" + exeTime + "] bind[" + request.getBindLog() + "]");
        }
    }

    protected SqlRow readRow(RelationalQueryRequest request) throws SQLException {
        return request.createNewRow(this.dbTrueValue);
    }
}

