/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.QueryIterator;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import java.util.Collection;
import java.util.List;

public class DefaultOrmQueryEngine
implements OrmQueryEngine {
    private final CQueryEngine queryEngine;

    public DefaultOrmQueryEngine(CQueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    private <T> void flushJdbcBatchOnQuery(OrmQueryRequest<T> request) {
        Transaction t = request.getTransaction();
        if (t.isBatchFlushOnQuery()) {
            t.flushBatch();
        }
    }

    @Override
    public <T> int delete(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.delete(request);
    }

    @Override
    public <T> int update(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.update(request);
    }

    @Override
    public <T> int findRowCount(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findRowCount(request);
    }

    @Override
    public <T> BeanIdList findIds(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIds(request);
    }

    @Override
    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIterate(request);
    }

    @Override
    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findVersions(request);
    }

    @Override
    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.getBeanFinder();
        BeanCollection<T> result = finder != null && finder.isInterceptFindMany(request) ? finder.findMany(request) : this.queryEngine.findMany(request);
        Query query = request.getQuery();
        if (query.isLoadBeanCache()) {
            BeanDescriptor<T> descriptor = request.getBeanDescriptor();
            Collection<T> c = result.getActualDetails();
            for (T bean : c) {
                descriptor.cacheBeanPut((EntityBean)bean);
            }
        }
        if (!result.isEmpty() && query.isUseQueryCache()) {
            request.putToQueryCache(result);
        }
        return result;
    }

    @Override
    public <T> T findId(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.getBeanFinder();
        T result = finder != null && finder.isInterceptFind(request) ? finder.find(request) : this.queryEngine.find(request);
        if (result != null && request.isUseBeanCache()) {
            request.getBeanDescriptor().cacheBeanPut((EntityBean)result);
        }
        return result;
    }
}

