/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Transaction;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.query.UtilJdbc;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

public class CQueryRowCount {
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private ResultSet rset;
    private PreparedStatement pstmt;
    private String bindLog;
    private int executionTimeMicros;
    private int rowCount;

    public CQueryRowCount(OrmQueryRequest<?> request, CQueryPredicates predicates, String sql) {
        this.request = request;
        this.query = request.getQuery();
        this.sql = sql;
        this.query.setGeneratedSql(sql);
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindRowCount exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.getFullName()).append("] predicates[").append(this.predicates.getLogWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findRowCount() throws SQLException {
        long startNano = System.nanoTime();
        try {
            Transaction t = this.request.getTransaction();
            Connection conn = t.getInternalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            this.bindLog = this.predicates.bind(this.pstmt, conn);
            this.rset = this.pstmt.executeQuery();
            if (!this.rset.next()) {
                throw new PersistenceException("Expecting 1 row but got none?");
            }
            this.rowCount = this.rset.getInt(1);
            long exeNano = System.nanoTime() - startNano;
            this.executionTimeMicros = (int)exeNano / 1000;
            int n = this.rowCount;
            return n;
        }
        finally {
            this.close();
        }
    }

    private void close() {
        UtilJdbc.close(this.rset);
        UtilJdbc.close(this.pstmt);
        this.rset = null;
        this.pstmt = null;
    }
}

