/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.RawSql;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.RsetDataReaderIndexed;
import java.sql.ResultSet;
import java.util.List;

public class CQueryPlanRawSql
extends CQueryPlan {
    private final int[] rsetIndexPositions;

    public CQueryPlanRawSql(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, String logWhereSql) {
        super(request, sqlRes, sqlTree, true, logWhereSql);
        this.rsetIndexPositions = this.createIndexPositions(request, sqlTree);
    }

    @Override
    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReaderIndexed(this.dataTimeZone, rset, this.rsetIndexPositions, this.isRowNumberIncluded());
    }

    private int[] createIndexPositions(OrmQueryRequest<?> request, SqlTree sqlTree) {
        int i;
        List<String> chain = sqlTree.buildRawSqlSelectChain();
        RawSql.ColumnMapping columnMapping = request.getQuery().getRawSql().getColumnMapping();
        int[] indexPositions = new int[chain.size()];
        for (i = 0; i < chain.size(); ++i) {
            indexPositions[i] = 1 + columnMapping.getIndexPosition(chain.get(i));
        }
        for (i = 0; i < indexPositions.length; ++i) {
            if (indexPositions[i] != 0 || i >= indexPositions.length) continue;
            indexPositions[i] = indexPositions[i + 1] - 1;
        }
        return indexPositions;
    }
}

