/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebeaninternal.api.CQueryPlanKey;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.timezone.DataTimeZone;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.query.CQueryPlanStats;
import com.avaje.ebeaninternal.server.query.RawSqlQueryPlanKey;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.RsetDataReader;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryPlan {
    private static final Logger logger = LoggerFactory.getLogger(CQueryPlan.class);
    private final SpiEbeanServer server;
    private final boolean autoTuned;
    private final CQueryPlanKey planKey;
    private final boolean rawSql;
    private final boolean rowNumberIncluded;
    private final String sql;
    private final String logWhereSql;
    private final SqlTree sqlTree;
    private final BeanProperty[] encryptedProps;
    private final CQueryPlanStats stats;
    private final Class<?> beanType;
    protected final DataTimeZone dataTimeZone;
    private final int asOfTableCount;
    private volatile String auditQueryHash;

    public CQueryPlan(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, boolean rawSql, String logWhereSql) {
        this.server = request.getServer();
        this.dataTimeZone = this.server.getDataTimeZone();
        this.beanType = request.getBeanDescriptor().getBeanType();
        this.stats = new CQueryPlanStats(this, this.server.isCollectQueryOrigins());
        this.planKey = request.getQueryPlanKey();
        this.autoTuned = request.getQuery().isAutoTuned();
        this.asOfTableCount = request.getQuery().getAsOfTableCount();
        if (sqlRes != null) {
            this.sql = sqlRes.getSql();
            this.rowNumberIncluded = sqlRes.isIncludesRowNumberColumn();
        } else {
            this.sql = null;
            this.rowNumberIncluded = false;
        }
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
    }

    public CQueryPlan(OrmQueryRequest<?> request, String sql, SqlTree sqlTree, boolean rawSql, boolean rowNumberIncluded, String logWhereSql) {
        this.server = request.getServer();
        this.dataTimeZone = this.server.getDataTimeZone();
        this.beanType = request.getBeanDescriptor().getBeanType();
        this.stats = new CQueryPlanStats(this, this.server.isCollectQueryOrigins());
        this.planKey = this.buildPlanKey(sql, rawSql, rowNumberIncluded, logWhereSql);
        this.autoTuned = false;
        this.asOfTableCount = 0;
        this.sql = sql;
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.rowNumberIncluded = rowNumberIncluded;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
    }

    private CQueryPlanKey buildPlanKey(String sql, boolean rawSql, boolean rowNumberIncluded, String logWhereSql) {
        return new RawSqlQueryPlanKey(sql, rawSql, rowNumberIncluded, logWhereSql);
    }

    public String toString() {
        return this.beanType + " hash:" + this.planKey;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReader(this.dataTimeZone, rset);
    }

    public DataBind bindEncryptedProperties(PreparedStatement stmt, Connection conn) throws SQLException {
        DataBind dataBind = new DataBind(this.dataTimeZone, stmt, conn);
        if (this.encryptedProps != null) {
            for (int i = 0; i < this.encryptedProps.length; ++i) {
                String key = this.encryptedProps[i].getEncryptKey().getStringValue();
                dataBind.setString(key);
            }
        }
        return dataBind;
    }

    public int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    public boolean isAutoTuned() {
        return this.autoTuned;
    }

    public CQueryPlanKey getPlanKey() {
        return this.planKey;
    }

    public String getAuditQueryKey() {
        if (this.auditQueryHash == null) {
            this.auditQueryHash = this.calcAuditQueryKey();
        }
        return this.auditQueryHash;
    }

    private String calcAuditQueryKey() {
        return this.rawSql ? this.planKey.getPartialKey() + "_" + this.getSqlMd5Hash() : this.planKey.getPartialKey();
    }

    private String getSqlMd5Hash() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(this.sql.getBytes("UTF-8"));
            return this.digestToHex(digest);
        }
        catch (Exception e) {
            logger.error("Failed to MD5 hash the rawSql query", (Throwable)e);
            return "error";
        }
    }

    private String digestToHex(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public String getSql() {
        return this.sql;
    }

    public SqlTree getSqlTree() {
        return this.sqlTree;
    }

    public boolean isRawSql() {
        return this.rawSql;
    }

    public boolean isRowNumberIncluded() {
        return this.rowNumberIncluded;
    }

    public String getLogWhereSql() {
        return this.logWhereSql;
    }

    public void resetStatistics() {
        this.stats.reset();
    }

    public void executionTime(long loadedBeanCount, long timeMicros, ObjectGraphNode objectGraphNode) {
        this.stats.add(loadedBeanCount, timeMicros, objectGraphNode);
        if (objectGraphNode != null) {
            this.server.collectQueryStats(objectGraphNode, loadedBeanCount, timeMicros);
        }
    }

    public CQueryPlanStats.Snapshot getSnapshot(boolean reset) {
        return this.stats.getSnapshot(reset);
    }

    public CQueryPlanStats getQueryStats() {
        return this.stats;
    }

    public long getLastQueryTime() {
        return this.stats.getLastQueryTime();
    }
}

