/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.NodeUsageCollector;
import com.avaje.ebean.bean.NodeUsageListener;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.readaudit.ReadEvent;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.autotune.ProfilingListener;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.QueryIterator;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelp;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelpFactory;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.query.CQueryIteratorSimple;
import com.avaje.ebeaninternal.server.query.CQueryIteratorWithBuffer;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQuery<T>
implements DbReadContext,
CancelableQuery {
    private static final Logger logger = LoggerFactory.getLogger(CQuery.class);
    private static final int GLOBAL_ROW_LIMIT = Integer.valueOf(System.getProperty("ebean.query.globallimit", "1000000"));
    private int rowCount;
    private int loadedBeanCount;
    private boolean noMoreRows;
    private EntityBean nextBean;
    private EntityBean currentBean;
    private final BeanPropertyAssocMany<?> lazyLoadManyProperty;
    private Object lazyLoadParentId;
    private EntityBean lazyLoadParentBean;
    private final BeanCollection<T> collection;
    private final BeanCollectionHelp<T> help;
    private final OrmQueryRequest<T> request;
    private final BeanDescriptor<T> desc;
    private final SpiQuery<T> query;
    private final boolean disableLazyLoading;
    private Map<String, String> currentPathMap;
    private String currentPrefix;
    private final CQueryPredicates predicates;
    private final boolean rawSql;
    private final String sql;
    private final String logWhereSql;
    private final boolean rowNumberIncluded;
    private final SqlTreeNode rootNode;
    private final BeanPropertyAssocMany<?> manyProperty;
    private final int maxRowsLimit;
    private DataReader dataReader;
    private PreparedStatement pstmt;
    private boolean cancelled;
    private String bindLog;
    private final CQueryPlan queryPlan;
    private final SpiQuery.Mode queryMode;
    private final boolean autoTuneProfiling;
    private final ObjectGraphNode objectGraphNode;
    private final ProfilingListener profilingListener;
    private final WeakReference<NodeUsageListener> profilingListenerRef;
    private final Boolean readOnly;
    private long startNano;
    private long executionTimeMicros;
    private boolean auditFindIterate;
    private List<Object> auditFindIterateIds;

    public CQuery(OrmQueryRequest<T> request, CQueryPredicates predicates, CQueryPlan queryPlan) {
        this.request = request;
        this.queryPlan = queryPlan;
        this.query = request.getQuery();
        this.queryMode = this.query.getMode();
        this.lazyLoadManyProperty = this.query.getLazyLoadMany();
        this.readOnly = request.isReadOnly();
        this.disableLazyLoading = this.query.isDisableLazyLoading();
        this.objectGraphNode = this.query.getParentNode();
        this.profilingListener = this.query.getProfilingListener();
        this.autoTuneProfiling = this.profilingListener != null;
        this.profilingListenerRef = this.autoTuneProfiling ? new WeakReference<ProfilingListener>(this.profilingListener) : null;
        this.query.setGeneratedSql(queryPlan.getSql());
        SqlTree sqlTree = queryPlan.getSqlTree();
        this.rootNode = sqlTree.getRootNode();
        this.manyProperty = sqlTree.getManyProperty();
        this.sql = queryPlan.getSql();
        this.rawSql = queryPlan.isRawSql();
        this.rowNumberIncluded = queryPlan.isRowNumberIncluded();
        this.logWhereSql = queryPlan.getLogWhereSql();
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
        this.maxRowsLimit = this.query.getMaxRows() > 0 ? this.query.getMaxRows() : GLOBAL_ROW_LIMIT;
        this.help = this.createHelp(request);
        this.collection = this.help != null ? this.help.createEmptyNoParent() : null;
    }

    private BeanCollectionHelp<T> createHelp(OrmQueryRequest<T> request) {
        if (request.isFindById()) {
            return null;
        }
        SpiQuery.Type manyType = request.getQuery().getType();
        if (manyType == null) {
            return null;
        }
        return BeanCollectionHelpFactory.create(request);
    }

    @Override
    public boolean isDraftQuery() {
        return this.query.isAsDraft();
    }

    @Override
    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void propagateState(Object e) {
        if (Boolean.TRUE.equals(this.readOnly) && e instanceof EntityBean) {
            ((EntityBean)e)._ebean_getIntercept().setReadOnly(true);
        }
    }

    @Override
    public DataReader getDataReader() {
        return this.dataReader;
    }

    @Override
    public SpiQuery.Mode getQueryMode() {
        return this.queryMode;
    }

    public CQueryPredicates getPredicates() {
        return this.predicates;
    }

    public SpiOrmQueryRequest<?> getQueryRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        CQuery cQuery = this;
        synchronized (cQuery) {
            this.cancelled = true;
            if (this.pstmt != null) {
                try {
                    this.pstmt.cancel();
                }
                catch (SQLException e) {
                    String msg = "Error cancelling query";
                    throw new PersistenceException(msg, (Throwable)e);
                }
            }
        }
    }

    public boolean prepareBindExecuteQueryForwardOnly(boolean dbPlatformForwardOnlyHint) throws SQLException {
        return this.prepareBindExecuteQueryWithOption(dbPlatformForwardOnlyHint);
    }

    public boolean prepareBindExecuteQuery() throws SQLException {
        return this.prepareBindExecuteQueryWithOption(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareBindExecuteQueryWithOption(boolean forwardOnlyHint) throws SQLException {
        CQuery cQuery = this;
        synchronized (cQuery) {
            ResultSet suppliedResultSet;
            if (this.cancelled || this.query.isCancelled()) {
                this.cancelled = true;
                return false;
            }
            this.startNano = System.nanoTime();
            Transaction t = this.request.getTransaction();
            Connection conn = t.getInternalConnection();
            if (this.query.isRawSql() && (suppliedResultSet = this.query.getRawSql().getResultSet()) != null) {
                this.dataReader = this.queryPlan.createDataReader(suppliedResultSet);
                this.bindLog = "";
                return true;
            }
            if (forwardOnlyHint) {
                this.pstmt = conn.prepareStatement(this.sql, 1003, 1007);
                this.pstmt.setFetchSize(Integer.MIN_VALUE);
            } else {
                this.pstmt = conn.prepareStatement(this.sql);
            }
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            if (this.query.getBufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
            }
            DataBind dataBind = this.queryPlan.bindEncryptedProperties(this.pstmt, conn);
            this.bindLog = this.predicates.bind(dataBind);
            ResultSet rset = this.pstmt.executeQuery();
            this.dataReader = this.queryPlan.createDataReader(rset);
            return true;
        }
    }

    public void close() {
        try {
            if (this.auditFindIterateIds != null && !this.auditFindIterateIds.isEmpty()) {
                this.auditIterateLogMessage();
            }
        }
        catch (Throwable e) {
            logger.error("Error logging read audit logs", e);
        }
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            logger.error("Error closing dataReader", (Throwable)e);
        }
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException e) {
            logger.error("Error closing preparedStatement", (Throwable)e);
        }
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.request.getPersistenceContext();
    }

    @Override
    public void setLazyLoadedChildBean(EntityBean bean, Object lazyLoadParentId) {
        if (lazyLoadParentId != null) {
            if (!lazyLoadParentId.equals(this.lazyLoadParentId)) {
                this.lazyLoadParentBean = (EntityBean)this.lazyLoadManyProperty.getBeanDescriptor().contextGet(this.getPersistenceContext(), lazyLoadParentId);
                this.lazyLoadParentId = lazyLoadParentId;
            }
            this.lazyLoadManyProperty.addBeanToCollectionWithCreate(this.lazyLoadParentBean, bean, true);
        }
    }

    private boolean readNextBean() throws SQLException {
        if (!this.moveToNextRow()) {
            if (this.currentBean == null) {
                return false;
            }
            this.nextBean = this.currentBean;
            ++this.loadedBeanCount;
            return true;
        }
        ++this.loadedBeanCount;
        if (this.manyProperty == null) {
            this.nextBean = this.rootNode.load(this, null, null);
            return true;
        }
        if (this.nextBean == null) {
            this.nextBean = this.rootNode.load(this, null, null);
        } else {
            this.nextBean = this.currentBean;
            this.request.persistenceContextAdd(this.nextBean);
            if (this.checkForDifferentBean()) {
                return true;
            }
        }
        this.readUntilDifferentBeanStarted();
        return true;
    }

    private void readUntilDifferentBeanStarted() throws SQLException {
        while (this.moveToNextRow()) {
            if (!this.checkForDifferentBean()) continue;
            return;
        }
    }

    private boolean checkForDifferentBean() throws SQLException {
        this.currentBean = this.rootNode.load(this, null, null);
        return this.currentBean != this.nextBean;
    }

    private boolean moveToNextRow() throws SQLException {
        if (!this.dataReader.next()) {
            this.noMoreRows = true;
            return false;
        }
        ++this.rowCount;
        this.dataReader.resetColumnPosition();
        if (this.rowNumberIncluded) {
            this.dataReader.incrementPos(1);
        }
        return true;
    }

    public long getQueryExecutionTimeMicros() {
        return this.executionTimeMicros;
    }

    public boolean readBean() throws SQLException {
        boolean result = this.hasNext();
        this.updateExecutionStatistics();
        return result;
    }

    protected EntityBean next() {
        if (this.auditFindIterate) {
            this.auditIterateNextBean();
        }
        return this.nextBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNext() throws SQLException {
        CQuery cQuery = this;
        synchronized (cQuery) {
            if (this.noMoreRows || this.cancelled || this.loadedBeanCount >= this.maxRowsLimit) {
                return false;
            }
            return this.readNextBean();
        }
    }

    public List<Version<T>> readVersions() throws SQLException {
        Version version;
        ArrayList<Version<T>> versionList = new ArrayList<Version<T>>();
        while ((version = this.readNextVersion()) != null) {
            versionList.add(version);
        }
        this.updateExecutionStatistics();
        return versionList;
    }

    private Version readNextVersion() throws SQLException {
        if (this.moveToNextRow()) {
            return this.rootNode.loadVersion(this);
        }
        return null;
    }

    public BeanCollection<T> readCollection() throws SQLException {
        while (this.hasNext()) {
            EntityBean bean = this.next();
            this.help.add(this.collection, bean, false);
        }
        this.updateExecutionStatistics();
        return this.collection;
    }

    protected void updateExecutionStatistics() {
        try {
            long exeNano = System.nanoTime() - this.startNano;
            this.executionTimeMicros = TimeUnit.NANOSECONDS.toMicros(exeNano);
            if (this.autoTuneProfiling) {
                this.profilingListener.collectQueryInfo(this.objectGraphNode, this.loadedBeanCount, this.executionTimeMicros);
            }
            this.queryPlan.executionTime(this.loadedBeanCount, this.executionTimeMicros, this.objectGraphNode);
        }
        catch (Exception e) {
            logger.error("Error updating execution statistics", (Throwable)e);
        }
    }

    public QueryIterator<T> readIterate(int bufferSize, OrmQueryRequest<T> request) {
        if (bufferSize > 0) {
            return new CQueryIteratorWithBuffer<T>(this, request, bufferSize);
        }
        return new CQueryIteratorSimple<T>(this, request);
    }

    public String getLoadedRowDetail() {
        if (this.manyProperty == null) {
            return String.valueOf(this.rowCount);
        }
        return this.loadedBeanCount + ":" + this.rowCount;
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi) {
        path = this.getPath(path);
        this.request.getGraphContext().register(path, ebi);
    }

    @Override
    public void register(String path, BeanCollection<?> bc) {
        path = this.getPath(path);
        this.request.getGraphContext().register(path, bc);
    }

    @Override
    public boolean isRawSql() {
        return this.rawSql;
    }

    public String getLogWhereSql() {
        return this.logWhereSql;
    }

    @Override
    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.manyProperty;
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public SpiTransaction getTransaction() {
        return this.request.getTransaction();
    }

    public String getBeanName() {
        return this.desc.getName();
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    public PersistenceException createPersistenceException(SQLException e) {
        return CQuery.createPersistenceException(e, this.getTransaction(), this.bindLog, this.sql);
    }

    public static PersistenceException createPersistenceException(SQLException e, SpiTransaction t, String bindLog, String sql) {
        if (t.isLogSummary()) {
            String errMsg = StringHelper.replaceStringMulti(e.getMessage(), new String[]{"\r", "\n"}, "\\n ");
            String msg = "ERROR executing query:   bindLog[" + bindLog + "] error[" + errMsg + "]";
            t.logSummary(msg);
        }
        t.getConnection();
        String m = Message.msg("fetch.sqlerror", e.getMessage(), bindLog, sql);
        return new PersistenceException(m, (Throwable)e);
    }

    @Override
    public boolean isAutoTuneProfiling() {
        return this.autoTuneProfiling && this.query.isUsageProfiling();
    }

    private String getPath(String propertyName) {
        if (this.currentPrefix == null) {
            return propertyName;
        }
        if (propertyName == null) {
            return this.currentPrefix;
        }
        String path = this.currentPathMap.get(propertyName);
        if (path != null) {
            return path;
        }
        return this.currentPrefix + "." + propertyName;
    }

    @Override
    public void profileBean(EntityBeanIntercept ebi, String prefix) {
        ObjectGraphNode node = this.request.getGraphContext().getObjectGraphNode(prefix);
        ebi.setNodeUsageCollector(new NodeUsageCollector(node, this.profilingListenerRef));
    }

    @Override
    public void setCurrentPrefix(String currentPrefix, Map<String, String> currentPathMap) {
        this.currentPrefix = currentPrefix;
        this.currentPathMap = currentPathMap;
    }

    public void auditFind(EntityBean bean) {
        if (bean != null) {
            this.desc.readAuditBean(this.queryPlan.getAuditQueryKey(), this.bindLog, bean);
        }
    }

    public void auditFindMany() {
        if (!this.collection.isEmpty()) {
            ArrayList<Object> ids = new ArrayList<Object>(this.collection.size());
            Collection<T> underlyingBeans = this.collection.getActualDetails();
            for (T underlyingBean : underlyingBeans) {
                ids.add(this.desc.getIdForJson(underlyingBean));
            }
            ReadEvent futureReadEvent = this.query.getFutureFetchAudit();
            if (futureReadEvent == null) {
                this.desc.readAuditMany(this.queryPlan.getAuditQueryKey(), this.bindLog, ids);
            } else {
                futureReadEvent.setQueryKey(this.queryPlan.getAuditQueryKey());
                futureReadEvent.setBindLog(this.bindLog);
                futureReadEvent.setIds(ids);
                this.desc.readAuditFutureMany(futureReadEvent);
            }
        }
    }

    public void auditFindIterate() {
        this.auditFindIterate = true;
    }

    private void auditIterateLogMessage() {
        this.desc.readAuditMany(this.queryPlan.getAuditQueryKey(), this.bindLog, this.auditFindIterateIds);
        this.auditFindIterateIds = null;
    }

    private void auditIterateNextBean() {
        if (this.auditFindIterateIds == null) {
            this.auditFindIterateIds = new ArrayList<Object>(100);
        }
        this.auditFindIterateIds.add(this.desc.getIdForJson(this.nextBean));
        if (this.auditFindIterateIds.size() >= 100) {
            this.auditIterateLogMessage();
        }
    }
}

