/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.ConcurrencyMode;
import com.avaje.ebeaninternal.api.SpiUpdatePlan;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dml.UpdatePlan;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;
import java.util.ArrayList;

public final class UpdateMeta {
    private final BindableList set;
    private final BindableId id;
    private final Bindable version;
    private final String tableName;
    private final UpdatePlan modeNoneUpdatePlan;
    private final UpdatePlan modeVersionUpdatePlan;
    private final boolean emptyStringAsNull;

    public UpdateMeta(boolean emptyStringAsNull, BeanDescriptor<?> desc, BindableList set, BindableId id, Bindable version) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.tableName = desc.getBaseTable();
        this.set = set;
        this.id = id;
        this.version = version;
        String sqlNone = this.genSql(ConcurrencyMode.NONE, set, desc.getBaseTable());
        String sqlVersion = this.genSql(ConcurrencyMode.VERSION, set, desc.getBaseTable());
        this.modeNoneUpdatePlan = new UpdatePlan(ConcurrencyMode.NONE, sqlNone, set);
        this.modeVersionUpdatePlan = new UpdatePlan(ConcurrencyMode.VERSION, sqlVersion, set);
    }

    public boolean isEmptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void bind(PersistRequestBean<?> persist, DmlHandler bind, SpiUpdatePlan updatePlan) throws SQLException {
        EntityBean bean = persist.getEntityBean();
        updatePlan.bindSet(bind, bean);
        this.id.dmlBind(bind, bean);
        switch (persist.getConcurrencyMode()) {
            case VERSION: {
                this.version.dmlBind(bind, bean);
                break;
            }
        }
    }

    public SpiUpdatePlan getUpdatePlan(PersistRequestBean<?> request) {
        if (request.isDynamicUpdateSql()) {
            return this.getDynamicUpdatePlan(request);
        }
        ConcurrencyMode mode = request.determineConcurrencyMode();
        switch (mode) {
            case NONE: {
                return this.modeNoneUpdatePlan;
            }
            case VERSION: {
                return this.modeVersionUpdatePlan;
            }
        }
        throw new RuntimeException("Invalid mode " + (Object)((Object)mode));
    }

    private SpiUpdatePlan getDynamicUpdatePlan(PersistRequestBean<?> persistRequest) {
        int key = persistRequest.getUpdatePlanHash();
        BeanDescriptor<?> beanDescriptor = persistRequest.getBeanDescriptor();
        SpiUpdatePlan updatePlan = beanDescriptor.getUpdatePlan(key);
        if (updatePlan != null) {
            return updatePlan;
        }
        ArrayList<Bindable> list = new ArrayList<Bindable>();
        this.set.addToUpdate(persistRequest, list);
        BindableList bindableList = new BindableList(list);
        ConcurrencyMode mode = persistRequest.determineConcurrencyMode();
        String sql = this.genSql(mode, bindableList, persistRequest.getUpdateTable());
        updatePlan = new UpdatePlan(key, mode, sql, bindableList);
        beanDescriptor.putUpdatePlan(key, updatePlan);
        return updatePlan;
    }

    private String genSql(ConcurrencyMode conMode, BindableList bindableList, String tableName) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        request.append("update ").append(tableName).append(" set ");
        request.setUpdateSetMode();
        bindableList.dmlAppend(request);
        if (request.getBindColumnCount() == 0) {
            return null;
        }
        request.append(" where ");
        request.setWhereIdMode();
        this.id.dmlAppend(request);
        if (ConcurrencyMode.VERSION.equals((Object)conMode)) {
            if (this.version == null) {
                return null;
            }
            this.version.dmlAppend(request);
        }
        return request.toString();
    }
}

