/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableDiscriminator;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;

public final class InsertMeta {
    private final String sqlNullId;
    private final String sqlWithId;
    private final String sqlDraftNullId;
    private final String sqlDraftWithId;
    private final BindableId id;
    private final Bindable discriminator;
    private final BindableList all;
    private final BindableList allExcludeDraftOnly;
    private final boolean supportsGetGeneratedKeys;
    private final boolean concatinatedKey;
    private final String selectLastInsertedId;
    private final Bindable shadowFKey;
    private final String[] identityDbColumns;
    private final boolean emptyStringToNull;

    public InsertMeta(DatabasePlatform dbPlatform, BeanDescriptor<?> desc, Bindable shadowFKey, BindableId id, BindableList all) {
        this.emptyStringToNull = dbPlatform.isTreatEmptyStringsAsNull();
        this.discriminator = InsertMeta.getDiscriminator(desc);
        this.id = id;
        this.all = all;
        this.allExcludeDraftOnly = all.excludeDraftOnly();
        this.shadowFKey = shadowFKey;
        String tableName = desc.getBaseTable();
        String draftTableName = desc.getDraftTable();
        this.sqlWithId = this.genSql(false, tableName, false);
        String string = this.sqlDraftWithId = desc.isDraftable() ? this.genSql(false, draftTableName, true) : this.sqlWithId;
        if (id.isConcatenated()) {
            this.concatinatedKey = true;
            this.identityDbColumns = null;
            this.sqlNullId = null;
            this.sqlDraftNullId = null;
            this.supportsGetGeneratedKeys = false;
            this.selectLastInsertedId = null;
        } else {
            this.concatinatedKey = false;
            if (id.getIdentityColumn() == null) {
                this.identityDbColumns = new String[0];
                this.supportsGetGeneratedKeys = false;
                this.selectLastInsertedId = null;
            } else {
                this.identityDbColumns = new String[]{id.getIdentityColumn()};
                this.supportsGetGeneratedKeys = dbPlatform.getDbIdentity().isSupportsGetGeneratedKeys();
                this.selectLastInsertedId = desc.getSelectLastInsertedId();
            }
            this.sqlNullId = this.genSql(true, tableName, false);
            this.sqlDraftNullId = desc.isDraftable() ? this.genSql(true, draftTableName, true) : this.sqlNullId;
        }
    }

    private static Bindable getDiscriminator(BeanDescriptor<?> desc) {
        InheritInfo inheritInfo = desc.getInheritInfo();
        if (inheritInfo != null) {
            return new BindableDiscriminator(inheritInfo);
        }
        return null;
    }

    public boolean isEmptyStringToNull() {
        return this.emptyStringToNull;
    }

    public boolean isConcatenatedKey() {
        return this.concatinatedKey;
    }

    public String[] getIdentityDbColumns() {
        return this.identityDbColumns;
    }

    public String getSelectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    public boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        return this.id.deriveConcatenatedId(persist);
    }

    public void bind(DmlHandler request, EntityBean bean, boolean withId, boolean publish) throws SQLException {
        if (withId) {
            this.id.dmlBind(request, bean);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlBind(request, bean);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlBind(request, bean);
        }
        if (publish) {
            this.allExcludeDraftOnly.dmlBind(request, bean);
        } else {
            this.all.dmlBind(request, bean);
        }
    }

    public String getSql(boolean withId, boolean publish) {
        if (withId) {
            return publish ? this.sqlWithId : this.sqlDraftWithId;
        }
        return publish ? this.sqlNullId : this.sqlDraftNullId;
    }

    private String genSql(boolean nullId, String table, boolean draftTable) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        request.setInsertSetMode();
        request.append("insert into ").append(table);
        request.append(" (");
        if (!nullId) {
            this.id.dmlAppend(request);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlAppend(request);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlAppend(request);
        }
        if (draftTable) {
            this.all.dmlAppend(request);
        } else {
            this.allExcludeDraftOnly.dmlAppend(request);
        }
        request.append(") values (");
        request.append(request.getInsertBindBuffer());
        request.append(")");
        return request.toString();
    }
}

