/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import com.avaje.ebeaninternal.server.persist.BeanPersister;
import com.avaje.ebeaninternal.server.persist.dml.DeleteHandler;
import com.avaje.ebeaninternal.server.persist.dml.DeleteMeta;
import com.avaje.ebeaninternal.server.persist.dml.InsertHandler;
import com.avaje.ebeaninternal.server.persist.dml.InsertMeta;
import com.avaje.ebeaninternal.server.persist.dml.PersistHandler;
import com.avaje.ebeaninternal.server.persist.dml.UpdateHandler;
import com.avaje.ebeaninternal.server.persist.dml.UpdateMeta;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

public final class DmlBeanPersister
implements BeanPersister {
    private final UpdateMeta updateMeta;
    private final InsertMeta insertMeta;
    private final DeleteMeta deleteMeta;

    public DmlBeanPersister(UpdateMeta updateMeta, InsertMeta insertMeta, DeleteMeta deleteMeta) {
        this.updateMeta = updateMeta;
        this.insertMeta = insertMeta;
        this.deleteMeta = deleteMeta;
    }

    @Override
    public int delete(PersistRequestBean<?> request) {
        DeleteHandler delete = new DeleteHandler(request, this.deleteMeta);
        return this.execute(request, delete);
    }

    @Override
    public void insert(PersistRequestBean<?> request) {
        InsertHandler insert = new InsertHandler(request, this.insertMeta);
        this.execute(request, insert);
    }

    @Override
    public void update(PersistRequestBean<?> request) {
        UpdateHandler update = new UpdateHandler(request, this.updateMeta);
        this.execute(request, update);
    }

    private int execute(PersistRequestBean<?> request, PersistHandler handler) {
        boolean batched = request.isBatched();
        try {
            handler.bind();
            if (batched) {
                handler.addBatch();
                int n = -1;
                return n;
            }
            int n = handler.execute();
            return n;
        }
        catch (SQLException e) {
            String errMsg = StringHelper.replaceStringMulti(e.getMessage(), new String[]{"\r", "\n"}, "\\n ");
            String msg = "ERROR executing DML bindLog[" + handler.getBindLog() + "] error[" + errMsg + "]";
            if (request.getTransaction().isLogSummary()) {
                request.getTransaction().logSummary(msg);
            }
            throw new PersistenceException(msg, (Throwable)e);
        }
        finally {
            if (!batched && handler != null) {
                handler.close();
            }
        }
    }
}

