/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.grammer;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.LikeType;
import com.avaje.ebeaninternal.server.grammer.EqlAdapter;
import com.avaje.ebeaninternal.server.grammer.EqlOperator;
import java.math.BigDecimal;
import java.util.List;

class EqlAdapterHelper {
    private final EqlAdapter owner;

    public EqlAdapterHelper(EqlAdapter owner) {
        this.owner = owner;
    }

    private ValueType getValueType(String valueAsText) {
        char firstChar = Character.toLowerCase(valueAsText.charAt(0));
        switch (firstChar) {
            case ':': {
                return ValueType.NAMED_PARAM;
            }
            case 't': {
                return ValueType.BOOL;
            }
            case 'f': {
                return ValueType.BOOL;
            }
            case '\'': {
                return ValueType.STRING;
            }
        }
        if (Character.isDigit(firstChar)) {
            return ValueType.NUMBER;
        }
        throw new IllegalArgumentException("Unexpected first character in value [" + valueAsText + "]");
    }

    protected void addBetweenProperty(String rawValue, String lowProperty, String highProperty) {
        this.peekExprList().betweenProperties(lowProperty, highProperty, this.bind(rawValue));
    }

    protected void addBetween(String path, String value1, String value2) {
        this.peekExprList().between(path, this.bind(value1), this.bind(value2));
    }

    protected void addIn(String path, List<Object> inValues) {
        this.peekExprList().in(path, inValues);
    }

    protected void addExpression(String path, EqlOperator op, String value) {
        switch (op) {
            case EQ: {
                this.peekExprList().eq(path, this.bind(value));
                break;
            }
            case IEQ: {
                this.peekExprList().add(this.owner.ieq(path, this.bind(value)));
                break;
            }
            case NE: {
                this.peekExprList().ne(path, this.bind(value));
                break;
            }
            case GT: {
                this.peekExprList().gt(path, this.bind(value));
                break;
            }
            case LT: {
                this.peekExprList().lt(path, this.bind(value));
                break;
            }
            case GTE: {
                this.peekExprList().ge(path, this.bind(value));
                break;
            }
            case LTE: {
                this.peekExprList().le(path, this.bind(value));
                break;
            }
            case LIKE: {
                this.addLike(false, LikeType.RAW, path, this.bind(value));
                break;
            }
            case CONTAINS: {
                this.addLike(false, LikeType.CONTAINS, path, this.bind(value));
                break;
            }
            case STARTS_WITH: {
                this.addLike(false, LikeType.STARTS_WITH, path, this.bind(value));
                break;
            }
            case ENDS_WITH: {
                this.addLike(false, LikeType.ENDS_WITH, path, this.bind(value));
                break;
            }
            case ILIKE: {
                this.addLike(true, LikeType.RAW, path, this.bind(value));
                break;
            }
            case ICONTAINS: {
                this.addLike(true, LikeType.CONTAINS, path, this.bind(value));
                break;
            }
            case ISTARTS_WITH: {
                this.addLike(true, LikeType.STARTS_WITH, path, this.bind(value));
                break;
            }
            case IENDS_WITH: {
                this.addLike(true, LikeType.ENDS_WITH, path, this.bind(value));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + (Object)((Object)op));
            }
        }
    }

    private void addLike(boolean caseInsensitive, LikeType likeType, String path, Object bindValue) {
        this.peekExprList().add(this.owner.like(caseInsensitive, likeType, path, bindValue));
    }

    protected Object bind(String value) {
        ValueType valueType = this.getValueType(value);
        return this.getBindValue(valueType, value);
    }

    private ExpressionList peekExprList() {
        return this.owner.peekExprList();
    }

    private Object getBindValue(ValueType valueType, String value) {
        switch (valueType) {
            case BOOL: {
                return Boolean.parseBoolean(value);
            }
            case NUMBER: {
                return new BigDecimal(value);
            }
            case STRING: {
                return this.unquote(value);
            }
            case NAMED_PARAM: {
                return this.owner.namedParam(value.substring(1));
            }
        }
        throw new IllegalArgumentException("Unhandled valueType " + (Object)((Object)valueType));
    }

    private String unquote(String value) {
        String raw = value.substring(1, value.length() - 1);
        return raw;
    }

    static enum ValueType {
        NAMED_PARAM,
        STRING,
        BOOL,
        NUMBER;

    }
}

