/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.IsEmptyExpression;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.io.IOException;

class NullExpression
extends AbstractExpression {
    private final boolean notNull;
    private ElPropertyValue elProperty;
    private boolean assocMany;
    private String propertyPath;

    NullExpression(String propertyName, boolean notNull) {
        super(propertyName);
        this.notNull = notNull;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.elProperty = desc.getElGetValue(this.propName);
        if (this.elProperty != null && this.elProperty.isAssocMany()) {
            this.assocMany = true;
            this.propertyPath = SplitName.split(this.propName)[0];
            this.propertyContainsMany(this.propertyPath, desc, manyWhereJoin);
        } else {
            this.propertyContainsMany(this.propName, desc, manyWhereJoin);
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeExists(this.notNull, this.propName);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String nullExpr;
        if (this.assocMany) {
            IsEmptyExpression.isEmptySql(request, this.elProperty, !this.notNull, this.propertyPath);
            return;
        }
        String string = nullExpr = this.notNull ? " is not null " : " is null ";
        if (this.elProperty != null && this.elProperty.isAssocId()) {
            request.append(this.elProperty.getAssocIdExpression(this.propName, nullExpr));
        } else {
            request.append(this.propName).append(nullExpr);
        }
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof NullExpression)) {
            return false;
        }
        NullExpression that = (NullExpression)other;
        return this.propName.equals(that.propName) && this.notNull == that.notNull;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return true;
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(NullExpression.class).add(this.notNull).add(this.propName);
    }

    @Override
    public int queryBindHash() {
        return this.notNull ? 1 : 0;
    }
}

