/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.Expression;
import com.avaje.ebean.Junction;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NestedPathWrapperExpression;
import java.io.IOException;

abstract class LogicExpression
implements SpiExpression {
    static final String AND = " and ";
    static final String OR = " or ";
    protected SpiExpression expOne;
    protected SpiExpression expTwo;
    private final String joinType;

    LogicExpression(String joinType, Expression expOne, Expression expTwo) {
        this.joinType = joinType;
        this.expOne = (SpiExpression)expOne;
        this.expTwo = (SpiExpression)expTwo;
    }

    @Override
    public void simplify() {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        boolean conjunction = this.joinType.equals(AND);
        context.startBool(conjunction ? Junction.Type.AND : Junction.Type.OR);
        this.expOne.writeDocQuery(context);
        this.expTwo.writeDocQuery(context);
        context.endBool();
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        String pathOne = this.expOne.nestedPath(desc);
        String pathTwo = this.expTwo.nestedPath(desc);
        if (pathOne == null && pathTwo == null) {
            return null;
        }
        if (pathOne != null && pathOne.equals(pathTwo)) {
            return pathOne;
        }
        if (pathOne != null) {
            this.expOne = new NestedPathWrapperExpression(pathOne, this.expOne);
        }
        if (pathTwo != null) {
            this.expTwo = new NestedPathWrapperExpression(pathTwo, this.expTwo);
        }
        return null;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.expOne.containsMany(desc, manyWhereJoin);
        this.expTwo.containsMany(desc, manyWhereJoin);
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        this.expOne.validate(validation);
        this.expTwo.validate(validation);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        this.expOne.addBindValues(request);
        this.expTwo.addBindValues(request);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append("(");
        this.expOne.addSql(request);
        request.append(this.joinType);
        this.expTwo.addSql(request);
        request.append(") ");
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.expOne.prepareExpression(request);
        this.expTwo.prepareExpression(request);
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(LogicExpression.class).add(this.joinType);
        this.expOne.queryPlanHash(builder);
        this.expTwo.queryPlanHash(builder);
    }

    @Override
    public int queryBindHash() {
        int hc = this.expOne.queryBindHash();
        hc = hc * 31 + this.expTwo.queryBindHash();
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof LogicExpression)) {
            return false;
        }
        LogicExpression that = (LogicExpression)other;
        return this.joinType.equals(that.joinType) && this.expOne.isSameByPlan(that.expOne) && this.expTwo.isSameByPlan(that.expTwo);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        LogicExpression that = (LogicExpression)other;
        return this.expOne.isSameByBind(that.expOne) && this.expTwo.isSameByBind(that.expTwo);
    }

    static class Or
    extends LogicExpression {
        Or(Expression expOne, Expression expTwo) {
            super(LogicExpression.OR, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new Or(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }

    static class And
    extends LogicExpression {
        And(Expression expOne, Expression expTwo) {
            super(LogicExpression.AND, expOne, expTwo);
        }

        @Override
        public SpiExpression copyForPlanKey() {
            return new And(this.expOne.copyForPlanKey(), this.expTwo.copyForPlanKey());
        }
    }
}

