/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NamedParamHelp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

class InExpression
extends AbstractExpression {
    private final boolean not;
    private final Collection<?> sourceValues;
    private Object[] bindValues;

    InExpression(String propertyName, Collection<?> sourceValues, boolean not) {
        super(propertyName);
        this.sourceValues = sourceValues;
        this.not = not;
    }

    InExpression(String propertyName, Object[] array, boolean not) {
        super(propertyName);
        this.sourceValues = Arrays.asList(array);
        this.not = not;
    }

    private Object[] values() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object sourceValue : this.sourceValues) {
            NamedParamHelp.valueAdd(vals, sourceValue);
        }
        return vals.toArray();
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.bindValues = this.values();
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeIn(this.propName, this.values(), this.not);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        for (int i = 0; i < this.bindValues.length; ++i) {
            if (prop == null) {
                request.addBindValue(this.bindValues[i]);
                continue;
            }
            Object[] ids = prop.getAssocIdValues((EntityBean)this.bindValues[i]);
            if (ids == null) continue;
            for (int j = 0; j < ids.length; ++j) {
                request.addBindValue(ids[j]);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.bindValues.length == 0) {
            String expr = this.not ? "1=1" : "1=0";
            request.append(expr);
            return;
        }
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        if (prop != null) {
            request.append(prop.getAssocIdInExpr(this.propName));
            String inClause = prop.getAssocIdInValueExpr(this.bindValues.length);
            request.append(inClause);
        } else {
            request.append(this.propName);
            if (this.not) {
                request.append(" not");
            }
            request.append(" in (?");
            for (int i = 1; i < this.bindValues.length; ++i) {
                request.append(", ").append("?");
            }
            request.append(" ) ");
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(InExpression.class).add(this.propName).add(this.bindValues.length).add(this.not);
        builder.bind(this.bindValues.length);
    }

    @Override
    public int queryBindHash() {
        int hc = 31;
        for (int i = 0; i < this.bindValues.length; ++i) {
            hc = 31 * hc + this.bindValues[i].hashCode();
        }
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof InExpression)) {
            return false;
        }
        InExpression that = (InExpression)other;
        return this.propName.equals(that.propName) && this.not == that.not && this.bindValues.length == that.bindValues.length;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InExpression that = (InExpression)other;
        if (this.bindValues.length != that.bindValues.length) {
            return false;
        }
        for (int i = 0; i < this.bindValues.length; ++i) {
            if (this.bindValues[i].equals(that.bindValues[i])) continue;
            return false;
        }
        return true;
    }
}

