/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.core.DbExpressionHandler;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DefaultExpressionRequest
implements SpiExpressionRequest {
    private final SpiOrmQueryRequest<?> queryRequest;
    private final BeanDescriptor<?> beanDescriptor;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> bindValues = new ArrayList<Object>();
    private final DeployParser deployParser;
    private final Binder binder;
    private final SpiExpressionList<?> expressionList;
    private int paramIndex;
    private StringBuilder bindLog;

    public DefaultExpressionRequest(SpiOrmQueryRequest<?> queryRequest, DeployParser deployParser, Binder binder, SpiExpressionList<?> expressionList) {
        this.queryRequest = queryRequest;
        this.beanDescriptor = queryRequest.getBeanDescriptor();
        this.deployParser = deployParser;
        this.binder = binder;
        this.expressionList = expressionList;
        expressionList.addBindValues(this);
    }

    public DefaultExpressionRequest(BeanDescriptor<?> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
        this.queryRequest = null;
        this.deployParser = null;
        this.binder = null;
        this.expressionList = null;
    }

    public String buildSql() {
        this.expressionList.addSql(this);
        return this.sql.toString();
    }

    public void bind(DataBind dataBind) throws SQLException {
        for (int i = 0; i < this.bindValues.size(); ++i) {
            Object bindValue = this.bindValues.get(i);
            this.binder.bindObject(dataBind, bindValue);
        }
        if (this.bindLog != null) {
            dataBind.append(this.bindLog.toString());
        }
    }

    @Override
    public DbExpressionHandler getDbPlatformHandler() {
        return this.binder.getDbExpressionHandler();
    }

    @Override
    public String parseDeploy(String logicalProp) {
        String s = this.deployParser.getDeployWord(logicalProp);
        return s == null ? logicalProp : s;
    }

    @Override
    public void appendLike() {
        this.sql.append(" ");
        this.sql.append(this.queryRequest.getDBLikeClause());
        this.sql.append(" ");
    }

    @Override
    public int nextParameter() {
        return ++this.paramIndex;
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public SpiOrmQueryRequest<?> getQueryRequest() {
        return this.queryRequest;
    }

    @Override
    public SpiExpressionRequest append(String sqlExpression) {
        this.sql.append(sqlExpression);
        return this;
    }

    @Override
    public void addBindEncryptKey(Object bindValue) {
        this.bindValues.add(bindValue);
        this.bindLog("****");
    }

    @Override
    public void addBindValue(Object bindValue) {
        this.bindValues.add(bindValue);
        this.bindLog(bindValue);
    }

    private void bindLog(Object val) {
        if (this.bindLog == null) {
            this.bindLog = new StringBuilder();
        } else {
            this.bindLog.append(",");
        }
        this.bindLog.append(val);
    }

    public String getBindLog() {
        return this.bindLog == null ? "" : this.bindLog.toString();
    }

    @Override
    public String getSql() {
        return this.sql.toString();
    }

    @Override
    public List<Object> getBindValues() {
        return this.bindValues;
    }
}

