/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchPath;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.Junction;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.Version;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.search.Match;
import com.avaje.ebean.search.MultiMatch;
import com.avaje.ebean.search.TextCommonTerms;
import com.avaje.ebean.search.TextQueryString;
import com.avaje.ebean.search.TextSimple;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.api.SpiJunction;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.JunctionExpression;
import com.avaje.ebeaninternal.server.expression.PrepareDocNested;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultExpressionList<T>
implements SpiExpressionList<T> {
    private static final String AND = " and ";
    protected List<SpiExpression> list;
    protected final Query<T> query;
    private final ExpressionList<T> parentExprList;
    protected transient ExpressionFactory expr;
    protected String allDocNestedPath;
    private final boolean textRoot;

    public DefaultExpressionList(Query<T> query) {
        this(query, query.getExpressionFactory(), null, new ArrayList<SpiExpression>(), true);
    }

    public DefaultExpressionList(Query<T> query, ExpressionList<T> parentExprList) {
        this(query, query.getExpressionFactory(), parentExprList);
    }

    DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList) {
        this(query, expr, parentExprList, new ArrayList<SpiExpression>());
    }

    DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList, List<SpiExpression> list) {
        this(query, expr, parentExprList, list, false);
    }

    private DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList, List<SpiExpression> list, boolean textRoot) {
        this.textRoot = textRoot;
        this.list = list;
        this.query = query;
        this.expr = expr;
        this.parentExprList = parentExprList;
    }

    private DefaultExpressionList() {
        this(null, null, null, new ArrayList<SpiExpression>());
    }

    SpiExpression wrap(List<SpiExpression> list, String nestedPath, Junction.Type type) {
        DefaultExpressionList<T> wrapper = new DefaultExpressionList<T>(this.query, this.expr, null, list, false);
        wrapper.setAllDocNested(nestedPath);
        if (type != null) {
            return new JunctionExpression<T>(type, wrapper);
        }
        return wrapper;
    }

    void simplifyEntries() {
        for (SpiExpression element : this.list) {
            element.simplify();
        }
    }

    @Override
    public void simplify() {
        this.simplifyEntries();
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (!this.textRoot) {
            this.writeDocQuery(context, null);
        } else {
            boolean implicitBool;
            if (this.list.isEmpty()) {
                throw new IllegalStateException("empty expression list?");
            }
            if (this.allDocNestedPath != null) {
                context.startNested(this.allDocNestedPath);
            }
            int size = this.list.size();
            SpiExpression first = this.list.get(0);
            boolean explicitBool = first instanceof SpiJunction;
            boolean bl = implicitBool = !explicitBool && size > 1;
            if (implicitBool || explicitBool) {
                context.startBoolGroup();
            }
            if (implicitBool) {
                context.startBoolGroupList(Junction.Type.SHOULD);
            }
            for (int i = 0; i < size; ++i) {
                SpiExpression expr = this.list.get(i);
                if (explicitBool) {
                    try {
                        ((SpiJunction)((Object)expr)).writeDocQueryJunction(context);
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalStateException("The top level text() expressions should be all be 'Must', 'Should' or 'Must Not' or none of them should be.", e);
                    }
                }
                expr.writeDocQuery(context);
            }
            if (implicitBool) {
                context.endBoolGroupList();
            }
            if (implicitBool || explicitBool) {
                context.endBoolGroup();
            }
            if (this.allDocNestedPath != null) {
                context.endNested();
            }
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context, SpiExpression idEquals) throws IOException {
        int size;
        if (this.allDocNestedPath != null) {
            context.startNested(this.allDocNestedPath);
        }
        if ((size = this.list.size()) == 1 && idEquals == null) {
            this.list.get(0).writeDocQuery(context);
        } else if (size == 0 && idEquals != null) {
            idEquals.writeDocQuery(context);
        } else {
            context.startBoolMust();
            if (idEquals != null) {
                idEquals.writeDocQuery(context);
            }
            for (int i = 0; i < size; ++i) {
                this.list.get(i).writeDocQuery(context);
            }
            context.endBool();
        }
        if (this.allDocNestedPath != null) {
            context.endNested();
        }
    }

    @Override
    public SpiExpressionList<?> trimPath(int prefixTrim) {
        throw new RuntimeException("Only allowed on FilterExpressionList");
    }

    public List<SpiExpression> internalList() {
        return this.list;
    }

    public DefaultExpressionList<T> copy(Query<T> query) {
        DefaultExpressionList<T> copy = new DefaultExpressionList<T>(query, this.expr, null);
        copy.list.addAll(this.list);
        return copy;
    }

    @Override
    public DefaultExpressionList<T> copyForPlanKey() {
        DefaultExpressionList<T> copy = new DefaultExpressionList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            copy.list.add(this.list.get(i).copyForPlanKey());
        }
        return copy;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins whereManyJoins) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).containsMany(desc, whereManyJoins);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).validate(validation);
        }
    }

    @Override
    public Query<T> query() {
        return this.query;
    }

    @Override
    public Query<T> asOf(Timestamp asOf) {
        return this.query.asOf(asOf);
    }

    @Override
    public Query<T> asDraft() {
        return this.query.asDraft();
    }

    @Override
    public Query<T> includeSoftDeletes() {
        return this.setIncludeSoftDeletes();
    }

    @Override
    public Query<T> setIncludeSoftDeletes() {
        return this.query.setIncludeSoftDeletes();
    }

    @Override
    public List<Version<T>> findVersions() {
        return this.query.findVersions();
    }

    @Override
    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.query.findVersionsBetween(start, end);
    }

    @Override
    public ExpressionList<T> where() {
        return this.query.where();
    }

    @Override
    public OrderBy<T> order() {
        return this.query.order();
    }

    @Override
    public OrderBy<T> orderBy() {
        return this.query.order();
    }

    @Override
    public Query<T> order(String orderByClause) {
        return this.query.order(orderByClause);
    }

    @Override
    public Query<T> orderBy(String orderBy) {
        return this.query.order(orderBy);
    }

    @Override
    public Query<T> setOrderBy(String orderBy) {
        return this.query.order(orderBy);
    }

    @Override
    public Query<T> apply(FetchPath fetchPath) {
        return this.query.apply(fetchPath);
    }

    @Override
    public int delete() {
        return this.query.delete();
    }

    @Override
    public int update() {
        return this.query.update();
    }

    @Override
    public FutureIds<T> findFutureIds() {
        return this.query.findFutureIds();
    }

    @Override
    public FutureRowCount<T> findFutureCount() {
        return this.query.findFutureCount();
    }

    @Override
    public FutureRowCount<T> findFutureRowCount() {
        return this.findFutureCount();
    }

    @Override
    public FutureList<T> findFutureList() {
        return this.query.findFutureList();
    }

    @Override
    public PagedList<T> findPagedList() {
        return this.query.findPagedList();
    }

    @Override
    public int findCount() {
        return this.query.findCount();
    }

    @Override
    public int findRowCount() {
        return this.findCount();
    }

    @Override
    public List<Object> findIds() {
        return this.query.findIds();
    }

    @Override
    public void findEach(QueryEachConsumer<T> consumer) {
        this.query.findEach(consumer);
    }

    @Override
    public void findEachWhile(QueryEachWhileConsumer<T> consumer) {
        this.query.findEachWhile(consumer);
    }

    @Override
    public List<T> findList() {
        return this.query.findList();
    }

    @Override
    public Set<T> findSet() {
        return this.query.findSet();
    }

    @Override
    public Map<?, T> findMap() {
        return this.query.findMap();
    }

    @Override
    public <K> Map<K, T> findMap(String keyProperty, Class<K> keyType) {
        return this.query.findMap(keyProperty, keyType);
    }

    @Override
    public T findUnique() {
        return this.query.findUnique();
    }

    @Override
    public ExpressionList<T> filterMany(String prop) {
        return this.query.filterMany(prop);
    }

    @Override
    public Query<T> select(String fetchProperties) {
        return this.query.select(fetchProperties);
    }

    @Override
    public Query<T> setDistinct(boolean distinct) {
        return this.query.setDistinct(distinct);
    }

    @Override
    public Query<T> setFirstRow(int firstRow) {
        return this.query.setFirstRow(firstRow);
    }

    @Override
    public Query<T> setMaxRows(int maxRows) {
        return this.query.setMaxRows(maxRows);
    }

    @Override
    public Query<T> setMapKey(String mapKey) {
        return this.query.setMapKey(mapKey);
    }

    @Override
    public Query<T> setUseCache(boolean useCache) {
        return this.query.setUseCache(useCache);
    }

    @Override
    public Query<T> setUseQueryCache(boolean useCache) {
        return this.query.setUseQueryCache(useCache);
    }

    @Override
    public Query<T> setUseDocStore(boolean useDocsStore) {
        return this.query.setUseDocStore(useDocsStore);
    }

    @Override
    public Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        return this.query.setDisableLazyLoading(disableLazyLoading);
    }

    @Override
    public Query<T> setDisableReadAuditing() {
        return this.query.setDisableReadAuditing();
    }

    @Override
    public ExpressionList<T> having() {
        return this.query.having();
    }

    @Override
    public ExpressionList<T> add(Expression expr) {
        this.list.add((SpiExpression)expr);
        return this;
    }

    @Override
    public ExpressionList<T> addAll(ExpressionList<T> exprList) {
        SpiExpressionList spiList = (SpiExpressionList)exprList;
        this.list.addAll(spiList.getUnderlyingList());
        return this;
    }

    @Override
    public List<SpiExpression> getUnderlyingList() {
        return this.list;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            SpiExpression expression = this.list.get(i);
            if (i > 0) {
                request.append(AND);
            }
            expression.addSql(request);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            this.list.get(i).addBindValues(request);
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            this.list.get(i).prepareExpression(request);
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(DefaultExpressionList.class);
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            this.list.get(i).queryPlanHash(builder);
        }
    }

    @Override
    public int queryBindHash() {
        int hash = DefaultExpressionList.class.getName().hashCode();
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            hash = hash * 31 + this.list.get(i).queryBindHash();
        }
        return hash;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof DefaultExpressionList)) {
            return false;
        }
        DefaultExpressionList that = (DefaultExpressionList)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            if (this.list.get(i).isSameByPlan(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        DefaultExpressionList that = (DefaultExpressionList)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            if (this.list.get(i).isSameByBind(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExpressionList<T> jsonExists(String propertyName, String path) {
        this.add(this.expr.jsonExists(propertyName, path));
        return this;
    }

    @Override
    public ExpressionList<T> jsonNotExists(String propertyName, String path) {
        this.add(this.expr.jsonNotExists(propertyName, path));
        return this;
    }

    @Override
    public ExpressionList<T> jsonEqualTo(String propertyName, String path, Object value) {
        this.add(this.expr.jsonEqualTo(propertyName, path, value));
        return this;
    }

    @Override
    public ExpressionList<T> jsonNotEqualTo(String propertyName, String path, Object val) {
        this.add(this.expr.jsonNotEqualTo(propertyName, path, val));
        return this;
    }

    @Override
    public ExpressionList<T> jsonGreaterThan(String propertyName, String path, Object val) {
        this.add(this.expr.jsonGreaterThan(propertyName, path, val));
        return this;
    }

    @Override
    public ExpressionList<T> jsonGreaterOrEqual(String propertyName, String path, Object val) {
        this.add(this.expr.jsonGreaterOrEqual(propertyName, path, val));
        return this;
    }

    @Override
    public ExpressionList<T> jsonLessThan(String propertyName, String path, Object val) {
        this.add(this.expr.jsonLessThan(propertyName, path, val));
        return this;
    }

    @Override
    public ExpressionList<T> jsonLessOrEqualTo(String propertyName, String path, Object val) {
        this.add(this.expr.jsonLessOrEqualTo(propertyName, path, val));
        return this;
    }

    @Override
    public ExpressionList<T> jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        this.add(this.expr.jsonBetween(propertyName, path, lowerValue, upperValue));
        return this;
    }

    @Override
    public ExpressionList<T> eq(String propertyName, Object value) {
        this.add(this.expr.eq(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> ieq(String propertyName, String value) {
        this.add(this.expr.ieq(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> ne(String propertyName, Object value) {
        this.add(this.expr.ne(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> allEq(Map<String, Object> propertyMap) {
        this.add(this.expr.allEq(propertyMap));
        return this;
    }

    @Override
    public ExpressionList<T> and(Expression expOne, Expression expTwo) {
        this.add(this.expr.and(expOne, expTwo));
        return this;
    }

    @Override
    public ExpressionList<T> between(String propertyName, Object value1, Object value2) {
        this.add(this.expr.between(propertyName, value1, value2));
        return this;
    }

    @Override
    public ExpressionList<T> betweenProperties(String lowProperty, String highProperty, Object value) {
        this.add(this.expr.betweenProperties(lowProperty, highProperty, value));
        return this;
    }

    @Override
    public ExpressionList<T> contains(String propertyName, String value) {
        this.add(this.expr.contains(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> endsWith(String propertyName, String value) {
        this.add(this.expr.endsWith(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> ge(String propertyName, Object value) {
        this.add(this.expr.ge(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> gt(String propertyName, Object value) {
        this.add(this.expr.gt(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> icontains(String propertyName, String value) {
        this.add(this.expr.icontains(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> idIn(Object ... idValues) {
        this.add(this.expr.idIn(idValues));
        return this;
    }

    @Override
    public ExpressionList<T> idIn(List<?> idList) {
        this.add(this.expr.idIn(idList));
        return this;
    }

    @Override
    public ExpressionList<T> idEq(Object value) {
        if (this.query != null && this.parentExprList == null) {
            this.query.setId(value);
        } else {
            this.add(this.expr.idEq(value));
        }
        return this;
    }

    @Override
    public ExpressionList<T> iendsWith(String propertyName, String value) {
        this.add(this.expr.iendsWith(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> ilike(String propertyName, String value) {
        this.add(this.expr.ilike(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> in(String propertyName, Query<?> subQuery) {
        this.add(this.expr.in(propertyName, subQuery));
        return this;
    }

    @Override
    public ExpressionList<T> in(String propertyName, Collection<?> values) {
        this.add(this.expr.in(propertyName, values));
        return this;
    }

    @Override
    public ExpressionList<T> in(String propertyName, Object ... values) {
        this.add(this.expr.in(propertyName, values));
        return this;
    }

    @Override
    public ExpressionList<T> notIn(String propertyName, Object ... values) {
        this.add(this.expr.notIn(propertyName, values));
        return this;
    }

    @Override
    public ExpressionList<T> notIn(String propertyName, Collection<?> values) {
        this.add(this.expr.notIn(propertyName, values));
        return this;
    }

    @Override
    public ExpressionList<T> notIn(String propertyName, Query<?> subQuery) {
        this.add(this.expr.notIn(propertyName, subQuery));
        return this;
    }

    @Override
    public ExpressionList<T> isEmpty(String propertyName) {
        this.add(this.expr.isEmpty(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> isNotEmpty(String propertyName) {
        this.add(this.expr.isNotEmpty(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> exists(Query<?> subQuery) {
        this.add(this.expr.exists(subQuery));
        return this;
    }

    @Override
    public ExpressionList<T> notExists(Query<?> subQuery) {
        this.add(this.expr.notExists(subQuery));
        return this;
    }

    @Override
    public ExpressionList<T> isNotNull(String propertyName) {
        this.add(this.expr.isNotNull(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> isNull(String propertyName) {
        this.add(this.expr.isNull(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> istartsWith(String propertyName, String value) {
        this.add(this.expr.istartsWith(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> le(String propertyName, Object value) {
        this.add(this.expr.le(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> exampleLike(Object example) {
        this.add(this.expr.exampleLike(example));
        return this;
    }

    @Override
    public ExpressionList<T> iexampleLike(Object example) {
        this.add(this.expr.iexampleLike(example));
        return this;
    }

    @Override
    public ExpressionList<T> like(String propertyName, String value) {
        this.add(this.expr.like(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> lt(String propertyName, Object value) {
        this.add(this.expr.lt(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> not(Expression exp) {
        this.add(this.expr.not(exp));
        return this;
    }

    @Override
    public ExpressionList<T> or(Expression expOne, Expression expTwo) {
        this.add(this.expr.or(expOne, expTwo));
        return this;
    }

    @Override
    public ExpressionList<T> arrayContains(String propertyName, Object ... elementValue) {
        this.add(this.expr.arrayContains(propertyName, elementValue));
        return this;
    }

    @Override
    public ExpressionList<T> arrayNotContains(String propertyName, Object ... values) {
        this.add(this.expr.arrayNotContains(propertyName, values));
        return this;
    }

    @Override
    public ExpressionList<T> arrayIsEmpty(String propertyName) {
        this.add(this.expr.arrayIsEmpty(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> arrayIsNotEmpty(String propertyName) {
        this.add(this.expr.arrayIsNotEmpty(propertyName));
        return this;
    }

    @Override
    public ExpressionList<T> raw(String raw, Object value) {
        this.add(this.expr.raw(raw, value));
        return this;
    }

    @Override
    public ExpressionList<T> raw(String raw, Object ... values) {
        this.add(this.expr.raw(raw, values));
        return this;
    }

    @Override
    public ExpressionList<T> raw(String raw) {
        this.add(this.expr.raw(raw));
        return this;
    }

    @Override
    public ExpressionList<T> startsWith(String propertyName, String value) {
        this.add(this.expr.startsWith(propertyName, value));
        return this;
    }

    @Override
    public ExpressionList<T> match(String propertyName, String search) {
        return this.match(propertyName, search, null);
    }

    @Override
    public ExpressionList<T> match(String propertyName, String search, Match options) {
        this.add(this.expr.textMatch(propertyName, search, options));
        this.setUseDocStore(true);
        return this;
    }

    @Override
    public ExpressionList<T> multiMatch(String query, String ... fields) {
        return this.multiMatch(query, MultiMatch.fields(fields));
    }

    @Override
    public ExpressionList<T> multiMatch(String query, MultiMatch options) {
        this.setUseDocStore(true);
        this.add(this.expr.textMultiMatch(query, options));
        return this;
    }

    @Override
    public ExpressionList<T> textSimple(String search, TextSimple options) {
        this.setUseDocStore(true);
        this.add(this.expr.textSimple(search, options));
        return this;
    }

    @Override
    public ExpressionList<T> textQueryString(String search, TextQueryString options) {
        this.setUseDocStore(true);
        this.add(this.expr.textQueryString(search, options));
        return this;
    }

    @Override
    public ExpressionList<T> textCommonTerms(String search, TextCommonTerms options) {
        this.setUseDocStore(true);
        this.add(this.expr.textCommonTerms(search, options));
        return this;
    }

    private Junction<T> junction(Junction.Type type) {
        Junction<T> junction = this.expr.junction(type, this.query, this);
        this.add(junction);
        return junction;
    }

    @Override
    public ExpressionList<T> endJunction() {
        return this.parentExprList == null ? this : this.parentExprList;
    }

    @Override
    public ExpressionList<T> endAnd() {
        return this.endJunction();
    }

    @Override
    public ExpressionList<T> endOr() {
        return this.endJunction();
    }

    @Override
    public ExpressionList<T> endNot() {
        return this.endJunction();
    }

    @Override
    public Junction<T> and() {
        return this.conjunction();
    }

    @Override
    public Junction<T> or() {
        return this.disjunction();
    }

    @Override
    public Junction<T> not() {
        return this.junction(Junction.Type.NOT);
    }

    @Override
    public Junction<T> conjunction() {
        return this.junction(Junction.Type.AND);
    }

    @Override
    public Junction<T> disjunction() {
        return this.junction(Junction.Type.OR);
    }

    @Override
    public Junction<T> must() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.MUST);
    }

    @Override
    public Junction<T> should() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.SHOULD);
    }

    @Override
    public Junction<T> mustNot() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.MUST_NOT);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    public void setAllDocNested(String allDocNestedPath) {
        this.allDocNestedPath = allDocNestedPath;
    }

    public void setUnderlying(List<SpiExpression> groupedByNesting) {
        this.list = groupedByNesting;
    }

    public void prepareDocNested(BeanDescriptor<T> beanDescriptor) {
        PrepareDocNested.prepare(this, beanDescriptor);
    }

    public Object idEqualTo(String idName) {
        if (this.list.size() == 1) {
            return this.list.get(0).getIdEqualTo(idName);
        }
        return null;
    }
}

