/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.ExampleExpression;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.avaje.ebean.LikeType;
import com.avaje.ebean.Query;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.search.Match;
import com.avaje.ebean.search.MultiMatch;
import com.avaje.ebean.search.TextCommonTerms;
import com.avaje.ebean.search.TextQueryString;
import com.avaje.ebean.search.TextSimple;
import com.avaje.ebeaninternal.api.SpiExpressionFactory;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.expression.AllEqualsExpression;
import com.avaje.ebeaninternal.server.expression.ArrayContainsExpression;
import com.avaje.ebeaninternal.server.expression.ArrayIsEmptyExpression;
import com.avaje.ebeaninternal.server.expression.BetweenExpression;
import com.avaje.ebeaninternal.server.expression.BetweenPropertyExpression;
import com.avaje.ebeaninternal.server.expression.CaseInsensitiveEqualExpression;
import com.avaje.ebeaninternal.server.expression.DefaultExampleExpression;
import com.avaje.ebeaninternal.server.expression.ExistsQueryExpression;
import com.avaje.ebeaninternal.server.expression.IdExpression;
import com.avaje.ebeaninternal.server.expression.IdInExpression;
import com.avaje.ebeaninternal.server.expression.InExpression;
import com.avaje.ebeaninternal.server.expression.InQueryExpression;
import com.avaje.ebeaninternal.server.expression.IsEmptyExpression;
import com.avaje.ebeaninternal.server.expression.JsonPathExpression;
import com.avaje.ebeaninternal.server.expression.JunctionExpression;
import com.avaje.ebeaninternal.server.expression.LikeExpression;
import com.avaje.ebeaninternal.server.expression.LogicExpression;
import com.avaje.ebeaninternal.server.expression.NativeILikeExpression;
import com.avaje.ebeaninternal.server.expression.NoopExpression;
import com.avaje.ebeaninternal.server.expression.NotExpression;
import com.avaje.ebeaninternal.server.expression.NullExpression;
import com.avaje.ebeaninternal.server.expression.Op;
import com.avaje.ebeaninternal.server.expression.RawExpression;
import com.avaje.ebeaninternal.server.expression.SimpleExpression;
import com.avaje.ebeaninternal.server.expression.TextCommonTermsExpression;
import com.avaje.ebeaninternal.server.expression.TextMatchExpression;
import com.avaje.ebeaninternal.server.expression.TextMultiMatchExpression;
import com.avaje.ebeaninternal.server.expression.TextQueryStringExpression;
import com.avaje.ebeaninternal.server.expression.TextSimpleExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DefaultExpressionFactory
implements SpiExpressionFactory {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final boolean nativeIlike;
    private final boolean equalsWithNullAsNoop;

    public DefaultExpressionFactory(boolean equalsWithNullAsNoop, boolean nativeIlike) {
        this.equalsWithNullAsNoop = equalsWithNullAsNoop;
        this.nativeIlike = nativeIlike;
    }

    @Override
    public ExpressionFactory createExpressionFactory() {
        return this;
    }

    public String getLang() {
        return "sql";
    }

    @Override
    public Expression textMatch(String propertyName, String search, Match options) {
        return new TextMatchExpression(propertyName, search, options);
    }

    @Override
    public Expression textMultiMatch(String query, MultiMatch options) {
        return new TextMultiMatchExpression(query, options);
    }

    @Override
    public Expression textSimple(String search, TextSimple options) {
        return new TextSimpleExpression(search, options);
    }

    @Override
    public Expression textQueryString(String search, TextQueryString options) {
        return new TextQueryStringExpression(search, options);
    }

    @Override
    public Expression textCommonTerms(String search, TextCommonTerms options) {
        return new TextCommonTermsExpression(search, options);
    }

    @Override
    public Expression jsonExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.EXISTS, null);
    }

    @Override
    public Expression jsonNotExists(String propertyName, String path) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EXISTS, null);
    }

    @Override
    public Expression jsonEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.EQ, value);
    }

    @Override
    public Expression jsonNotEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.NOT_EQ, value);
    }

    @Override
    public Expression jsonGreaterThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT, value);
    }

    @Override
    public Expression jsonGreaterOrEqual(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.GT_EQ, value);
    }

    @Override
    public Expression jsonLessThan(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT, value);
    }

    @Override
    public Expression jsonLessOrEqualTo(String propertyName, String path, Object value) {
        return new JsonPathExpression(propertyName, path, Op.LT_EQ, value);
    }

    @Override
    public Expression jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        return new JsonPathExpression(propertyName, path, lowerValue, upperValue);
    }

    @Override
    public Expression arrayContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, true, values);
    }

    @Override
    public Expression arrayNotContains(String propertyName, Object ... values) {
        return new ArrayContainsExpression(propertyName, false, values);
    }

    @Override
    public Expression arrayIsEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, true);
    }

    @Override
    public Expression arrayIsNotEmpty(String propertyName) {
        return new ArrayIsEmptyExpression(propertyName, false);
    }

    @Override
    public Expression eq(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.EQ, value);
    }

    @Override
    public Expression ne(String propertyName, Object value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNotNull(propertyName);
        }
        return new SimpleExpression(propertyName, Op.NOT_EQ, value);
    }

    @Override
    public Expression ieq(String propertyName, String value) {
        if (value == null) {
            return this.equalsWithNullAsNoop ? NoopExpression.INSTANCE : this.isNull(propertyName);
        }
        return new CaseInsensitiveEqualExpression(propertyName, value);
    }

    @Override
    public Expression ieqObject(String propertyName, Object value) {
        return new CaseInsensitiveEqualExpression(propertyName, value);
    }

    @Override
    public Expression between(String propertyName, Object value1, Object value2) {
        return new BetweenExpression(propertyName, value1, value2);
    }

    @Override
    public Expression betweenProperties(String lowProperty, String highProperty, Object value) {
        return new BetweenPropertyExpression(lowProperty, highProperty, value);
    }

    @Override
    public Expression gt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT, value);
    }

    @Override
    public Expression ge(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.GT_EQ, value);
    }

    @Override
    public Expression lt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT, value);
    }

    @Override
    public Expression le(String propertyName, Object value) {
        return new SimpleExpression(propertyName, Op.LT_EQ, value);
    }

    @Override
    public Expression isNull(String propertyName) {
        return new NullExpression(propertyName, false);
    }

    @Override
    public Expression isNotNull(String propertyName) {
        return new NullExpression(propertyName, true);
    }

    private EntityBean checkEntityBean(Object bean) {
        if (bean == null || !(bean instanceof EntityBean)) {
            throw new IllegalStateException("Expecting an EntityBean");
        }
        return (EntityBean)bean;
    }

    @Override
    public ExampleExpression iexampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), true, LikeType.RAW);
    }

    @Override
    public ExampleExpression exampleLike(Object example) {
        return new DefaultExampleExpression(this.checkEntityBean(example), false, LikeType.RAW);
    }

    @Override
    public ExampleExpression exampleLike(Object example, boolean caseInsensitive, LikeType likeType) {
        return new DefaultExampleExpression(this.checkEntityBean(example), caseInsensitive, likeType);
    }

    @Override
    public Expression like(String propertyName, Object value, boolean caseInsensitive, LikeType likeType) {
        return new LikeExpression(propertyName, value, caseInsensitive, likeType);
    }

    @Override
    public Expression like(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.RAW);
    }

    @Override
    public Expression ilike(String propertyName, String value) {
        if (this.nativeIlike) {
            return new NativeILikeExpression(propertyName, value);
        }
        return new LikeExpression(propertyName, value, true, LikeType.RAW);
    }

    @Override
    public Expression startsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.STARTS_WITH);
    }

    @Override
    public Expression istartsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.STARTS_WITH);
    }

    @Override
    public Expression endsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.ENDS_WITH);
    }

    @Override
    public Expression iendsWith(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.ENDS_WITH);
    }

    @Override
    public Expression contains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, false, LikeType.CONTAINS);
    }

    @Override
    public Expression icontains(String propertyName, String value) {
        return new LikeExpression(propertyName, value, true, LikeType.CONTAINS);
    }

    @Override
    public Expression in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, false);
    }

    @Override
    public Expression in(String propertyName, Query<?> subQuery) {
        return new InQueryExpression(propertyName, (SpiQuery)subQuery, false);
    }

    @Override
    public Expression in(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, false);
    }

    @Override
    public Expression notIn(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, true);
    }

    @Override
    public Expression notIn(String propertyName, Collection<?> values) {
        return new InExpression(propertyName, values, true);
    }

    @Override
    public Expression notIn(String propertyName, Query<?> subQuery) {
        return new InQueryExpression(propertyName, (SpiQuery)subQuery, true);
    }

    @Override
    public Expression exists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, false);
    }

    @Override
    public Expression notExists(Query<?> subQuery) {
        return new ExistsQueryExpression((SpiQuery)subQuery, true);
    }

    @Override
    public Expression isEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, true);
    }

    @Override
    public Expression isNotEmpty(String propertyName) {
        return new IsEmptyExpression(propertyName, false);
    }

    @Override
    public Expression idEq(Object value) {
        if (value == null) {
            throw new NullPointerException("The id value is null");
        }
        return new IdExpression(value);
    }

    @Override
    public Expression idIn(List<?> idList) {
        return new IdInExpression(idList);
    }

    @Override
    public Expression idIn(Object ... idValues) {
        return new IdInExpression(Arrays.asList(idValues));
    }

    @Override
    public Expression allEq(Map<String, Object> propertyMap) {
        return new AllEqualsExpression(propertyMap);
    }

    @Override
    public Expression raw(String raw, Object value) {
        return new RawExpression(raw, new Object[]{value});
    }

    @Override
    public Expression raw(String raw, Object[] values) {
        return new RawExpression(raw, values);
    }

    @Override
    public Expression raw(String raw) {
        return new RawExpression(raw, EMPTY_ARRAY);
    }

    @Override
    public Expression and(Expression expOne, Expression expTwo) {
        return new LogicExpression.And(expOne, expTwo);
    }

    @Override
    public Expression or(Expression expOne, Expression expTwo) {
        return new LogicExpression.Or(expOne, expTwo);
    }

    @Override
    public Expression not(Expression exp) {
        return new NotExpression(exp);
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.AND, query, query.where());
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query) {
        return new JunctionExpression<T>(Junction.Type.OR, query, query.where());
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.AND, query, parent);
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(Junction.Type.OR, query, parent);
    }

    public <T> Junction<T> junction(Junction.Type type, Query<T> query) {
        return new JunctionExpression<T>(type, query, query.where());
    }

    @Override
    public <T> Junction<T> junction(Junction.Type type, Query<T> query, ExpressionList<T> parent) {
        return new JunctionExpression<T>(type, query, parent);
    }
}

