/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NamedParamHelp;
import com.avaje.ebeaninternal.server.expression.Op;
import java.io.IOException;

class BetweenExpression
extends AbstractExpression {
    private static final String BETWEEN = " between ";
    private final Object valueHigh;
    private final Object valueLow;

    BetweenExpression(String propertyName, Object valueLow, Object valueHigh) {
        super(propertyName);
        this.valueLow = valueLow;
        this.valueHigh = valueHigh;
    }

    private Object low() {
        return NamedParamHelp.value(this.valueLow);
    }

    private Object high() {
        return NamedParamHelp.value(this.valueHigh);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeRange(this.propName, Op.GT_EQ, this.low(), Op.LT_EQ, this.high());
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.low());
        request.addBindValue(this.high());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(this.propName).append(BETWEEN).append(" ? and ? ");
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(BetweenExpression.class).add(this.propName);
        builder.bind(2);
    }

    @Override
    public int queryBindHash() {
        int hc = this.low().hashCode();
        hc = hc * 31 + this.high().hashCode();
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof BetweenExpression)) {
            return false;
        }
        BetweenExpression that = (BetweenExpression)other;
        return this.propName.equals(that.propName);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        BetweenExpression that = (BetweenExpression)other;
        return this.low().equals(that.low()) && this.high().equals(that.high());
    }
}

