/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.id;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanFkeyProperty;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.IntersectionRow;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import com.avaje.ebeaninternal.server.deploy.id.ImportedIdSimple;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableRequest;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

public class ImportedIdEmbedded
implements ImportedId {
    private final BeanPropertyAssoc<?> owner;
    private final BeanPropertyAssocOne<?> foreignAssocOne;
    private final ImportedIdSimple[] imported;

    public ImportedIdEmbedded(BeanPropertyAssoc<?> owner, BeanPropertyAssocOne<?> foreignAssocOne, ImportedIdSimple[] imported) {
        this.owner = owner;
        this.foreignAssocOne = foreignAssocOne;
        this.imported = imported;
    }

    @Override
    public void addFkeys(String name) {
        BeanProperty[] embeddedProps = this.foreignAssocOne.getProperties();
        for (int i = 0; i < this.imported.length; ++i) {
            String n = name + "." + this.foreignAssocOne.getName() + "." + embeddedProps[i].getName();
            BeanFkeyProperty fkey = new BeanFkeyProperty(n, this.imported[i].localDbColumn, this.foreignAssocOne.getDeployOrder());
            this.owner.getBeanDescriptor().add(fkey);
        }
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public String getLogicalName() {
        return this.owner.getName() + "." + this.foreignAssocOne.getName();
    }

    @Override
    public String getDbColumn() {
        return null;
    }

    @Override
    public void sqlAppend(DbSqlContext ctx) {
        for (int i = 0; i < this.imported.length; ++i) {
            ctx.appendColumn(this.imported[i].localDbColumn);
        }
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        for (int i = 0; i < this.imported.length; ++i) {
            request.appendColumn(this.imported[i].localDbColumn);
        }
    }

    @Override
    public void dmlWhere(GenerateDmlRequest request, EntityBean bean) {
        Object embeddedId = null;
        if (bean != null) {
            embeddedId = this.foreignAssocOne.getValue(bean);
        }
        if (embeddedId == null) {
            for (int i = 0; i < this.imported.length; ++i) {
                if (!this.imported[i].owner.isDbUpdatable()) continue;
                request.appendColumnIsNull(this.imported[i].localDbColumn);
            }
        } else {
            EntityBean embedded = (EntityBean)embeddedId;
            for (int i = 0; i < this.imported.length; ++i) {
                if (!this.imported[i].owner.isDbUpdatable()) continue;
                Object value = this.imported[i].foreignProperty.getValue(embedded);
                if (value == null) {
                    request.appendColumnIsNull(this.imported[i].localDbColumn);
                    continue;
                }
                request.appendColumn(this.imported[i].localDbColumn);
            }
        }
    }

    @Override
    public Object bind(BindableRequest request, EntityBean bean) throws SQLException {
        Object embeddedId = null;
        if (bean != null) {
            embeddedId = this.foreignAssocOne.getValue(bean);
        }
        if (embeddedId == null) {
            for (int i = 0; i < this.imported.length; ++i) {
                if (!this.imported[i].owner.isUpdateable()) continue;
                request.bind(null, this.imported[i].foreignProperty);
            }
        } else {
            EntityBean embedded = (EntityBean)embeddedId;
            for (int i = 0; i < this.imported.length; ++i) {
                if (!this.imported[i].owner.isUpdateable()) continue;
                Object scalarValue = this.imported[i].foreignProperty.getValue(embedded);
                request.bind(scalarValue, this.imported[i].foreignProperty);
            }
        }
        return null;
    }

    @Override
    public void buildImport(IntersectionRow row, EntityBean other) {
        EntityBean embeddedId = (EntityBean)this.foreignAssocOne.getValue(other);
        if (embeddedId == null) {
            String msg = "Foreign Key value null?";
            throw new PersistenceException(msg);
        }
        for (int i = 0; i < this.imported.length; ++i) {
            Object scalarValue = this.imported[i].foreignProperty.getValue(embeddedId);
            row.put(this.imported[i].localDbColumn, scalarValue);
        }
    }

    @Override
    public BeanProperty findMatchImport(String matchDbColumn) {
        for (int i = 0; i < this.imported.length; ++i) {
            BeanProperty p = this.imported[i].findMatchImport(matchDbColumn);
            if (p == null) continue;
            return p;
        }
        return null;
    }
}

