/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.generatedproperty;

import com.avaje.ebean.config.ClassLoadConfig;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedUpdateDate;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedUpdateJavaTime;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedUpdateJodaTime;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedUpdateLong;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedUpdateTimestamp;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;

public class UpdateTimestampFactory {
    final GeneratedUpdateLong longTime = new GeneratedUpdateLong();
    final Map<Class<?>, GeneratedProperty> map = new HashMap();

    public UpdateTimestampFactory(ClassLoadConfig classLoadConfig) {
        this.map.put(Timestamp.class, new GeneratedUpdateTimestamp());
        this.map.put(Date.class, new GeneratedUpdateDate());
        this.map.put(Long.class, this.longTime);
        this.map.put(Long.TYPE, this.longTime);
        if (classLoadConfig.isJavaTimePresent()) {
            this.map.put(Instant.class, new GeneratedUpdateJavaTime.InstantDT());
            this.map.put(java.time.LocalDateTime.class, new GeneratedUpdateJavaTime.LocalDT());
            this.map.put(OffsetDateTime.class, new GeneratedUpdateJavaTime.OffsetDT());
            this.map.put(ZonedDateTime.class, new GeneratedUpdateJavaTime.ZonedDT());
        }
        if (classLoadConfig.isJodaTimePresent()) {
            this.map.put(LocalDateTime.class, new GeneratedUpdateJodaTime.LocalDT());
            this.map.put(DateTime.class, new GeneratedUpdateJodaTime.DateTimeDT());
        }
    }

    public void setUpdateTimestamp(DeployBeanProperty property) {
        property.setGeneratedProperty(this.createUpdateTimestamp(property));
    }

    protected GeneratedProperty createUpdateTimestamp(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        GeneratedProperty generatedProperty = this.map.get(propType);
        if (generatedProperty != null) {
            return generatedProperty;
        }
        throw new PersistenceException("Generated update Timestamp not supported on " + propType.getName());
    }
}

