/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLoadManager {
    private static final Logger logger = LoggerFactory.getLogger(PostLoadManager.class);
    private final List<BeanPostLoad> list;

    public PostLoadManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPostLoaders();
    }

    public int getRegisterCount() {
        return this.list.size();
    }

    public void addPostLoad(DeployBeanDescriptor<?> deployDesc) {
        for (int i = 0; i < this.list.size(); ++i) {
            BeanPostLoad c = this.list.get(i);
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            logger.debug("BeanPostLoad on[" + deployDesc.getFullName() + "] " + c.getClass().getName());
            deployDesc.addPostLoad(c);
        }
    }
}

